#include "/usr/local/sh-linux-elf/include/bfd.h"
#include "../../../gcc/gdb-5.0/include/dis-asm.h"

unsigned short *sh4_ram;
unsigned long sh4_ram_base, sh4_ram_size;

/* These are supposed to be defined in libbfd, damn it */
bfd_vma bfd_getl16(const unsigned char *bytes) {
	return ((int)bytes[0])
		| (((int)bytes[1]) << 8);
}

bfd_vma bfd_getl32(const unsigned char *bytes) {
	return ((int)bytes[0])
		| (((int)bytes[1]) << 8)
		| (((int)bytes[2]) << 16)
		| (((int)bytes[3]) << 24);
}

bfd_vma bfd_getb16(const unsigned char *bytes) { return 0; }
bfd_vma bfd_getb32(const unsigned char *bytes) { return 0; }


/* "read memory", hehe */
int read_mem(bfd_vma memaddr, bfd_byte *myaddr, unsigned int len,
		struct disassemble_info *info) {
	memcpy(myaddr, sh4_ram + (memaddr - sh4_ram_base)/2, len);
	return 0;
}

void mem_error(int status, bfd_vma memaddr,
		struct disassemble_info *info) {
	printf("Memory error at %08x", memaddr);
}

void print_addr(bfd_vma addr, struct disassemble_info *info) {
	printf("%08x", addr);
}

/* Put it all together */
void do_disassembly() {
	bfd_vma memaddr = sh4_ram_base;
	disassemble_info info;
	int i;

	INIT_DISASSEMBLE_INFO_NO_ARCH(info, stdout, (fprintf_ftype)fprintf);
	info.flavour = bfd_mach_sh4;
	info.mach = bfd_mach_sh4;
	info.read_memory_func = read_mem;
	info.memory_error_func = mem_error;
	info.print_address_func = print_addr;

	for (i=0; i<sh4_ram_size; i+=2) {
		int c1, c2;
		memaddr = i + sh4_ram_base;

		c1 = sh4_ram[i/2] & 0xff;
		c2 = (sh4_ram[i/2] >> 8) & 0xff;
		if (c1 < 32 || c1 > 127) c1 = '.';
		if (c2 < 32 || c2 > 127) c2 = '.';
		fprintf(stdout, "0x%08x: %04x  %c%c  ",
			sh4_ram_base + i,
			sh4_ram[i/2],
			c1,
			c2);
		print_insn_shl(memaddr, &info);
		fprintf(stdout, "\n");
	}
}

int main(int argc, char **argv) {
	FILE *f;
	int vma;
	int s;

	if (argc < 3) {
		printf("usage: da <binary file> <vma>\n"
			"Note: <vma> is a hex number, WITHOUT leading 0x\n");
		return 0;
	}

	sh4_ram_base = strtoul(argv[2], NULL, 16);
	printf("! Disassembled from %s, with VMA 0x%08x\n",
		argv[1], sh4_ram_base);

	f = fopen(argv[1], "r");
	if (!f) {
		perror("Couldn't open file");
		return 0;
	}

	fseek(f, 0, SEEK_END); s=ftell(f); fseek(f, 0, SEEK_SET);
	sh4_ram_size = s;
	sh4_ram = malloc(sh4_ram_size);
	fread(sh4_ram, sh4_ram_size, 1, f);

	fclose(f);

	do_disassembly();

	return 0;
}

