####################################################################
# Disassembler stuff
import da
import string

class Disassembler:
	def __init__(self):
		f = open("test.bin", "r")
		self.buffer = f.read()
		f.close()

		da.init(self.read, self.err)

	def read(self, addr, len):
		return self.buffer[addr:addr+len]

	def err(self, status, addr):
		print "Memory error! Status is", status, "addr is", addr

	def disasm(self, addr):
		# Get the raw disassembled instruction
		r = da.disassemble_insn(addr, 0)

		# Split it into tabbed columns
		cols = string.split(r, "\t")

		# One column version: return the string
		if len(cols) == 1:
			return cols[0]
		# Two columns: at 0 and 10
		elif len(cols) == 2:
			return cols[0] + " "*(10-len(cols[0])) \
				+ cols[1]
		# Three columns: at 0, 10, and 20
		elif len(cols) == 3:
			return cols[0] + " "*(10-len(cols[0])) \
				+ cols[1] + " "*(20-len(cols[1])) \
				+ cols[2]


def test_disasm():
	d = Disassembler()
	for i in range(0, 100, 2):
		print "%08x\t%s" % (i, d.disasm(i))

