####################################################################
# Serial stuff

import sys, os, string
import termios, TERMIOS
import select

class Serial:
	def __init__(self, baud):
		self.mf = open("/dev/ttyS0", "r+")
		self.mfd = self.mf.fileno()

		self.old = termios.tcgetattr(self.mfd)
		new = termios.tcgetattr(self.mfd)

		# Translate the baud rate
		bd = getattr(TERMIOS, 'B' + str(baud))

		# Input flags
		new[0] = 0
		# Output flags
		new[1] = 0
		# Control flags
		new[2] = (new[2] & ~(TERMIOS.CSIZE | TERMIOS.PARENB)) \
			| (TERMIOS.CS8 | TERMIOS.CRTSCTS | TERMIOS.CLOCAL)
		# Local flags
		new[3] = 0
		new[4] = bd		# Set i/o speed
		new[5] = bd
		termios.tcsetattr(self.mfd, TERMIOS.TCSANOW, new)

	def close(self):
		termios.tcsetattr(self.mfd, TERMIOS.TCSADRAIN, self.old)
	

	def interact(self):
		while 1:
			i, o, e = select.select([sys.stdin, self.mf], [], [])

			if i[0] is sys.stdin:
				line = sys.stdin.readline()[:-1]
				if line == 'quit': return
				self.mf.write(line + "\r\n")
			elif i[0] is self.mf:
				data = os.read(self.mfd, 1024)
				# data = string.replace(data, "\r", "")
				sys.stdout.write(data)
				sys.stdout.flush()
	
	def putch(self, ch):
		self.mf.write(ch)
		self.mf.flush()
	
	def getch(self):
		return self.mf.read(1)


def test_serial():
	serial = Serial(57600)
	serial.interact()
	serial.close()

