#include <Python.h>
#include <stdarg.h>

#include "/usr/local/sh-linux-elf/include/bfd.h"
#include "../../../gcc/gdb-5.0/include/dis-asm.h"

static int call_mem_callback(unsigned long addr, unsigned long len, unsigned char *buffer);
static void call_err_callback(unsigned long status, unsigned long addr);

/* These are supposed to be defined in libbfd, damn it */
bfd_vma bfd_getl16(const unsigned char *bytes) {
	return ((int)bytes[0])
		| (((int)bytes[1]) << 8);
}

bfd_vma bfd_getl32(const unsigned char *bytes) {
	return ((int)bytes[0])
		| (((int)bytes[1]) << 8)
		| (((int)bytes[2]) << 16)
		| (((int)bytes[3]) << 24);
}

bfd_vma bfd_getb16(const unsigned char *bytes) { return 0; }
bfd_vma bfd_getb32(const unsigned char *bytes) { return 0; }

char output_buffer[2048] = {0};
int printf_to_string(int nothing, char *fmt, ...) {
	va_list		args;
	int		rv;

	va_start(args, fmt);
	rv = vsprintf(output_buffer + strlen(output_buffer), fmt, args);
	va_end(args);

	return rv;
}

/* "read memory", hehe */
int read_mem(bfd_vma memaddr, bfd_byte *myaddr, unsigned int len,
		struct disassemble_info *info) {
	return call_mem_callback(memaddr, len, (unsigned char *)myaddr);
}

void mem_error(int status, bfd_vma memaddr,
		struct disassemble_info *info) {
	call_err_callback(status, memaddr);
}

void print_addr(bfd_vma addr, struct disassemble_info *info) {
	printf_to_string(0, "%08x", addr);
}



/*************************************************************************
 * Python API exposure for the disassembler module
 *************************************************************************/

static PyObject *read_mem_callback, *error_callback;
static disassemble_info info;

/* This calls the Python callback for reading one memory word.. the function
 * should take an address (long) and a byte count, and return the memory 
 * bytes (string). If the memory cannot be read, then None should be returned.
 */
static int call_mem_callback(unsigned long addr, unsigned long len, unsigned char *buffer) {
	PyObject *result = PyObject_CallFunction(read_mem_callback, "ll", addr, len);
	char *rs;
	int rl;

	if (!result) {
		PyErr_Print();
		return 0;
	}
	
	if (result == Py_None)
		return 1;
	
	rs = PyString_AsString(result);
	rl = PyString_Size(result);
	memcpy(buffer, rs, rl);
	Py_DECREF(result);
	
	return 0;
}

/* Calls the Python callback for memory read errors. The function should take
 * a status (long) and an address (long), and handle the error however appropriate.
 */
static void call_err_callback(unsigned long status, unsigned long addr) {
	if (!PyObject_CallFunction(error_callback, "ll", status, addr)) {
		PyErr_Print();
	}
}

/* We expect a callback Python function to read memory, and an error
 * handler if it fails. */ 
static PyObject* da_init(PyObject* self, PyObject* args) {
	if (!PyArg_ParseTuple(args, "OO", &read_mem_callback, &error_callback)) {
		PyErr_Print();
		return NULL;
	}
	Py_INCREF(read_mem_callback);
	Py_INCREF(error_callback);
	
	INIT_DISASSEMBLE_INFO_NO_ARCH(info, stdout, (fprintf_ftype)printf_to_string);
	info.flavour = bfd_mach_sh4;
	info.mach = bfd_mach_sh4;
	info.read_memory_func = read_mem;
	info.memory_error_func = mem_error;
	info.print_address_func = print_addr;

	return Py_BuildValue("i", 0);
}

static PyObject* da_disassemble_insn(PyObject* self, PyObject* args) {
	bfd_vma memaddr;
	int i;
	unsigned long junk;
	PyObject *rv;
	
	if (!PyArg_ParseTuple(args, "ll", &memaddr, &junk)) {
		PyErr_Print();
		return NULL;
	}

	print_insn_shl(memaddr, &info);
	rv = Py_BuildValue("s", output_buffer);
	output_buffer[0] = '\0';
	
	return rv;
}


static PyMethodDef da_methods[] = {
	{"init",		(PyCFunction)da_init, 0},
	{"disassemble_insn",	(PyCFunction)da_disassemble_insn, 0},
	{NULL, NULL, 0}
};

static PyObject* interp_da_module = NULL;

void initda() {
	interp_da_module = Py_InitModule("da", da_methods);
}
