#include "dream.h"
#include "cp850.h"

static char version_info[] = "debug_test (c)2000 Dan Potter";

void gdb_mode();
void breakpoint();

void pretty_display() {
//	unsigned long * vm = (unsigned long *)0xa5000000;
	unsigned short * vm = (unsigned long *)0xa5000000;
	int r, g, b, x, y;
	for (y=0; y<480; y++) {
		for (x=0; x<640; x++) {
			r = ((x * x) + (y * y)) & 255;
			g = ((x * x) - (y * y)) & 255;
			b = (x ^ y) & 255;

			r = r / 8;
			g = g / 16;

			// *vm = (r << 16) | (g << 8) | b;
			*vm = ((r >> 3) << 11)
				| ((g >> 2) << 5)
				| ((b >> 3) << 0);
			vm++;
		}
	}
}

void go_rom() {
	unsigned long *syscalle0 = (unsigned long *)0x8c0000e0;
	unsigned short *rom = ((unsigned short *)(*syscalle0)) - 1;
//	unsigned short *rom = (unsigned short *)(0x8c000178 - 2);
	void (*jump)(int) = rom;

	unsigned short *tmp = (unsigned short *)(0xac0002c8);
	tmp[8] = 0x0009;
	tmp[14] = 0x0009;
	tmp = (unsigned short *)(0xac000c44);
	tmp[0] = 0x0009;
	tmp[2] = 0x0009;
	tmp = (unsigned short *)(0xac005b1a);
	tmp[0] = 0x0009;
	tmp = (unsigned short *)(0xac006b2a);
	tmp[0] = 0x0009;
	tmp = (unsigned short *)(0xac006ea4);
	tmp[0] = 0x0009;
	tmp = (unsigned short *)(0xac007824);
	tmp[0] = 0x0009;
	tmp = (unsigned short *)(0xac00c8d2);
	tmp[0] = 0x0009;
	tmp = (unsigned short *)(0xac00c962);
	tmp[0] = 0x0009;
	
	// flush_icache_range(0xac002c8, 0xac00c966);

	dc_serial_printf("Jumping into the ROM\r\n");
	*rom = 0xc300;
	flush_icache_range(rom, rom+1);
	jump(1);
}

void debug_test() {
	asm("
		trapa	#0
		nop
		nop
		nop
		nop
		nop
		nop
		nop
	");
}

void dc_main() {
	int type;

	dc_serial_init();
	dc_serial_printf("Video setup\r\n");
	dc_border_color(255, 255, 0);
	type = dc_check_cable();
	dc_init_video(type, PM_RGB565);
	dc_clear(0,0,0);
	dc_font_set(fnt_cp850, 8);

	dc_serial_printf("Setting GDB debug traps...\r\n");
	set_debug_traps();

	debug_test();

	// go_rom();

/*	dc_serial_printf("Type some text:\r\n");
	for (type=0; type<80; type++) {
		int c = get_debug_char();
		put_debug_char(c);
	} */

	pretty_display();
	return 0;
}



