/* KallistiOS 0.6
 *
 * controller.c
 * (C)2000 Jordan DeLong
 */

static char id[] = "KOS $Id: controller.c,v 1.2 2000/11/09 04:21:49 bard Exp $";

#include <kallisti/maple.h>
#include <kallisti/controller.h>
#include <stdio.h>

/* get the complete condition structure for controller on port
   and fill in cond with it, ret -1 on error */
int cont_get_cond(uint8 addr, cont_cond_t *cond) {
	maple_frame_t frame;
	uint32 param[1];

	param[0] = MAPLE_FUNC_CONTROLLER;

	do {
		if (maple_docmd_block(MAPLE_COMMAND_GETCOND, addr, 1, param, &frame) == -1)
			return -1;
	} while (frame.cmd == MAPLE_RESPONSE_AGAIN);

	/* response comes as func, data. */
	if (frame.cmd == MAPLE_RESPONSE_DATATRF
		&& (frame.datalen - 1) == sizeof(cont_cond_t) / 4
		&& *((uint32 *) frame.data) == MAPLE_FUNC_CONTROLLER) {
		memcpy(cond, frame.data + 4, (frame.datalen - 1) * 4);
	} else {
		return -1;
	}

	return 0;
}
