/* KallistiOS 0.6

   hardware.c
   (c)2000 Dan Potter
*/

static char id[] = "KOS $Id: hardware.c,v 1.2 2000/11/09 04:21:49 bard Exp $";

#include <kallisti/config.h>
#include <kallisti/serial.h>
#include <kallisti/spu.h>
#include <kallisti/video.h>
#include <kallisti/cdrom.h>
#include <kallisti/irq.h>
#include <kallisti/timer.h>

void hardware_init() {
	/* Initialized SCIF */
	serial_init(DEFAULT_SERIAL_BAUD, DEFAULT_SERIAL_FIFO);

	/* Init video */
	vid_init(DEFAULT_VID_MODE, DEFAULT_PIXEL_MODE);

	/* Init sound */
	spu_init();
	
	/* Init CD-ROM.. NOTE: NO GD-ROM SUPPORT. ONLY CDs/CDRs. */
	cdrom_init();

	/* Enable IRQs (ready for threads) */
	irq_init();

	/* Enable timers */
	timer_init();
}

void hardware_shutdown() {
	timer_shutdown();
	irq_shutdown();
	spu_shutdown();
	vid_shutdown();
}


