/* KallistiOS 0.6

   mouse.c
   (C)2000 Jordan DeLong
*/

static char id[] = "KOS $Id: mouse.c,v 1.3 2000/11/12 01:14:59 bard Exp $";

#include <kallisti/maple.h>
#include <kallisti/mouse.h>

/* get the condition structure for a mouse at address addr. return a
   -1 if an error occurs. */
int mouse_get_cond(uint8 addr, mouse_cond_t *cond) {
	maple_frame_t frame;
	uint32 param[1];

	param[0] = MAPLE_FUNC_MOUSE;

	do {
		if (maple_docmd_block(MAPLE_COMMAND_GETCOND, addr, 1, param, &frame) == -1)
			return -1;
	} while (frame.cmd == MAPLE_RESPONSE_AGAIN);

	/* we get back func,condition */
	if (frame.cmd == MAPLE_RESPONSE_DATATRF
		&& (frame.datalen - 1) == sizeof(mouse_cond_t) / 4
		&& *((uint32 *) frame.data) == MAPLE_FUNC_MOUSE) {
		memcpy(cond, frame.data + 4, (frame.datalen - 1) * 4);
	} else {
		return -1;
	}

	cond->dx -= MOUSE_DELTA_CENTER;
	cond->dy -= MOUSE_DELTA_CENTER;
	cond->dz -= MOUSE_DELTA_CENTER;

	return 0;
}

/* perform accelleration on the mouse cursor by using the old deltas in relation to
   the new ones, which are passed to us. */
int mouse_accel_deltas(mouse_cond_t *mouse, mouse_cond_t *oldmouse) {
	/* for now only x and y, z will be done later */
	return 0;
}
