/* KallistiOS 0.6

   serial_buffer.c
   (c)2000 Dan Potter
*/

static char id[] = "KOS $Id: serial_buffer.c,v 1.2 2000/11/12 01:04:59 bard Exp $";

#include <malloc.h>
#include <string.h>
#include <kallisti/serial.h>
#include <kallisti/irq.h>

/*

This module implements an IRQ-based serial buffering system for
the SCIF port. This is neccessary if you are using threads because
the read latency may cause you to lose data. If you enable
threading, then enable this module as well and use it to read
from the serial port. Even if you _might_ use threads, use this
module since it will pass through requests if it's not enabled.

THIS MODULE IS CURRENTLY BROKEN SO DON'T USE IT YET.

*/

/* Is it enabled? */
static int serbuf_enabled = 0;

/* Serial buffer itself */
#define SERBUF_SIZE 1024
static char *serbuf = NULL;
static volatile int sb_tail, sb_head;

/* SCIF interrupt handler */
static void serbuf_interrupt(uint32 type, uint32 code) {
	int i;

	/* Read chars */
	while ( (i=serial_read()) != -1 ) {
		//printf("%02x", i);
		serbuf[sb_head] = i;
		sb_head = (sb_head+1) & (SERBUF_SIZE-1);
	}
}

/* Dummy int handler for ints we don't want */
static void serbuf_dummy_int(uint32 type, uint32 code) {
	volatile uint16 *scif16 = (uint16*)0xffe80000;

	/* Clear status */
	scif16[16/2] = 0x60;
	scif16[36/2] = 0;
}

/* Program-level read */
int serbuf_read() {
	int c;

	if (!serbuf_enabled)
		return serial_read();
	
	if (sb_head == sb_tail)
		return -1;
	
	c = serbuf[sb_tail];
	sb_tail = (sb_tail+1) & (SERBUF_SIZE-1);
	
	return c;
}

/* Program-level block-read */
void serbuf_read_buffer(uint8 *data, int len) {
	int c, t;
	
	if (!serbuf_enabled) {
		serial_read_buffer(data, len);
		return;
	}

	while (len-- > 0) {
		while ( (c = serbuf_read()) == -1 )
			;
		*data++ = c;
	}
}

/* Initialze serial buffering */
int serbuf_init() {
	volatile uint16 *iprc = (uint16*)0xffd0000c;
	volatile uint16 *scif16 = (uint16*)0xffe80000;

	/* Init buffer */
	serbuf = malloc(SERBUF_SIZE);
	sb_tail = 0;
	sb_head = 0;

	/* Hook the SCIF interrupts */
	irq_set_handler(EXC_SCIF_RXI, serbuf_interrupt);
	irq_set_handler(EXC_SCIF_ERI, serbuf_dummy_int);
	irq_set_handler(EXC_SCIF_BRI, serbuf_dummy_int);

	/* Enable SCIF received interrupts */
	*iprc |= 0x000f << 4;

	/* Enable SCIF interrupts */
	scif16[8/2] |= 1<<6;

	/* Set enable */
	serbuf_enabled = 1;
}

/* Shutdown serial buffering */
void serbuf_shutdown() {
	volatile uint16 *iprc = (uint16*)0xffd0000c;
	volatile uint16 *scif16 = (uint16*)0xffe80000;

	/* Set disable */
	serbuf_enabled = 0;
	
	/* Disable SCIF interrupts */
	scif16[8/2] &= ~(1<<6);
	
	/* Disable SCIF received interrupts */
	*iprc &= ~(0x000f << 4);

	/* Unhook SCIF interrupt */
	irq_set_handler(EXC_SCIF_RXI, NULL);
	
	/* Free buffer */
	free(serbuf);
}






