/* KallistiOS 0.6

   kallisti/abi/fs.h
   (c)2000 Dan Potter

   $Id: fs.h,v 1.3 2000/11/09 04:41:02 bard Exp $
*/

#ifndef __KALLISTI_ABI_FS_H
#define __KALLISTI_ABI_FS_H

#include <kallisti/stdtypes.h>
#include <kallisti/process.h>
#include <kallisti/fs.h>

typedef struct {
	service_abi_t	hdr;		/* Header info */

	uint32		(*open)(char *fn, int mode);
	void		(*close)(uint32 hnd);
	ssize_t		(*read)(uint32 hnd, void *buffer, size_t cnt);
	ssize_t		(*write)(uint32 hnd, void *buffer, size_t cnt);
	off_t		(*seek)(uint32 hnd, off_t offset, int whence);
	off_t		(*tell)(uint32 hnd);
	size_t		(*total)(uint32 hnd);
	dirent_t*	(*readdir)(uint32 hnd);
	int		(*ioctl)(uint32 hnd, void *data, size_t size);
	int		(*rename)(const char *fn1, const char *fn2);
	int		(*unlink)(const char *fn);
	uint32		padding0[16 - 11];
	
	int		(*handler_add)(char *prefix, vfs_handler *hnd);
	int		(*handler_remove)(vfs_handler *hnd);
} abi_fs_t;

#endif	/* __KALLISTI_ABI_FS_H */

