/* KallistiOS 0.6

   kallisti/abi/maple.h
   (c)2000 Dan Potter

   $Id: maple.h,v 1.3 2000/11/09 04:41:02 bard Exp $

*/

#ifndef __KALLISTI_ABI_MAPLE_H
#define __KALLISTI_ABI_MAPLE_H

#include <kallisti/stdtypes.h>
#include <kallisti/process.h>
#include <kallisti/maple.h>

/* Specific maple devices */
#include <kallisti/controller.h>
#include <kallisti/keyboard.h>
#include <kallisti/mouse.h>
#include <kallisti/vmu.h>

typedef struct {
	service_abi_t	hdr;		/* Header info */

	uint8		(*create_addr)(uint8 port, uint8 unit);
	int		(*docmd_block)(int8 cmd, uint8 addr,
				uint8 datalen, void *data,
				maple_frame_t *retframe);
	int		(*rescan_bus)(int quiet);
	uint32		(*device_func)(int port, int unit);
	uint8		(*first_device)(int code);
	uint8		(*first_controller)();
	uint8		(*first_mouse)();
	uint8		(*first_kb)();
	uint8		(*first_lcd)();
	uint8		(*first_vmu)();
	uint32		padding0[32 - 10];

	int		(*cont_get_cond)(uint8 addr, cont_cond_t *cond);
	uint32		padding1[8 - 1];

	int		(*kbd_get_cond)(uint8 addr, kbd_cond_t *cond);
	void		(*kbd_set_queue)(int active);
	int		(*kbd_enqueue)(uint8 keyboard);
	int		(*kbd_get_key)();
	int		(*kbd_poll)(uint8 addr);
	uint32		padding2[8 - 5];

	int		(*mouse_get_cond)(uint8 addr, mouse_cond_t *cond);
	uint32		padding3[8 - 1];

	int		(*vmu_draw_lcd)(uint8 addr, void *bitmap);
	int		(*vmu_block_read)(uint8 addr, uint16 blocknum, uint8 *buffer);
	int		(*vmu_block_write)(uint8 addr, uint16 blocknum, uint8 *buffer);
} abi_maple_t;



#endif	/* __KALLISTI_ABI_MAPLE_H */
