/* KallistiOS 0.6

   kallisti/abi/spu.h
   (c)2000 Dan Potter

   $Id: spu.h,v 1.3 2000/11/09 04:41:02 bard Exp $

*/

#ifndef __KALLISTI_ABI_SPU_H
#define __KALLISTI_ABI_SPU_H

#include <kallisti/stdtypes.h>
#include <kallisti/process.h>
#include <kallisti/spu.h>

typedef struct {
	service_abi_t	hdr;		/* Header info */

	void	(*ram_write_wait)();
	void	(*memload)(uint32 to, uint8* from, int length);
	void	(*memset)(uint32 to, uint32 what, int length);
	void	(*enable)();
	void	(*disable)();
} abi_spu_t;

#endif	/* __KALLISTI_ABI_SPU_H */
