/* KallistiOS 0.6

   kallisti/abi/ta.h
   (c)2000 Dan Potter

   $Id: ta.h,v 1.3 2000/11/09 04:41:02 bard Exp $

*/

#ifndef __KALLISTI_ABI_TA_H
#define __KALLISTI_ABI_TA_H

#include <kallisti/stdtypes.h>
#include <kallisti/process.h>
#include <kallisti/ta.h>

typedef struct {
	service_abi_t	hdr;		/* Header info */

	void		(*hw_init)();
	void		(*hw_shutdown)();
	void		(*send_queue)(void *sql, int size);
	void		(*begin_render)();
	void		(*commit_poly_hdr)(void *polyhdr);
	void		(*commit_vertex)(void *vertex, int size);
	void		(*commit_eol)();
	void		(*finish_frame)();
	void		(*poly_hdr_col)(poly_hdr_t *target, int translucent);
	void		(*poly_hdr_txr)(poly_hdr_t *target, int translucent,
				int textureformat, int tw, int th, uint32 textureaddr,
				int filtering);
	void		(*load_texture)(uint32 dest, void *src, int size);
	void*		(*texture_map)(uint32 loc);
	uint32		padding0[32 - 12];
	
	/* Warning: this is likely to change at any given time */
	ta_bkg_poly	*bkg;
} abi_ta_t;



#endif	/* __KALLISTI_ABI_TA_H */
