/* KallistiOS 0.6

   kallisti/abi/thread.h
   (c)2000 Dan Potter

   $Id: thread.h,v 1.3 2000/11/09 04:41:02 bard Exp $

*/

#ifndef __KALLISTI_ABI_THREAD_H
#define __KALLISTI_ABI_THREAD_H

#include <kallisti/stdtypes.h>
#include <kallisti/process.h>
#include <kallisti/thread.h>

typedef struct {
	service_abi_t	hdr;		/* Header info */

	uint32		(*create)(void (*routine)(void *param), void *param);
	int		(*destroy)(uint32 tid);
	void		(*pass)();
	void		(*sleep_jiffies)(uint32 jif);
	void		(*sleep)(uint32 ms);
	void		(*mutex_reset)(volatile thd_mutex_t *mutex);
	void		(*mutex_lock)(volatile thd_mutex_t *mutex);
	void		(*mutex_unlock)(volatile thd_mutex_t *mutex);
	void		(*event_reset)(volatile thd_event_t *event);
	void		(*event_set)(volatile thd_event_t *event);
	void		(*event_wait)(volatile thd_event_t *event);
	uint32		(*jiffies)();
} abi_thread_t;



#endif	/* __KALLISTI_ABI_THREAD_H */
