/* KallistiOS 0.6

   kallisti/abi/video.h
   (c)2000 Dan Potter

   $Id: video.h,v 1.3 2000/11/09 04:41:02 bard Exp $

*/

#ifndef __KALLISTI_ABI_VIDEO_H
#define __KALLISTI_ABI_VIDEO_H

#include <kallisti/process.h>
#include <kallisti/video.h>
#include <kallisti/biosfont.h>

typedef struct {
	service_abi_t	hdr;		/* Header info */

	int		(*check_cable)();
	void		(*set_mode)(int ct, int vid_mode, int pixel_mode);
	void		(*set_start)(uint32 start);
	void		(*border_color)(int r, int g, int b);
	void		(*clear)(int r, int g, int b);
	void		(*empty)();
	void		(*waitvbl)();
	uint32		padding0[16-7];

	uint32		*vram_l;
	uint16		*vram_s;
	uint32		padding1[16-2];

	void*		(*bfont_find_char)(int ch);
	void		(*bfont_draw)(uint16 *buffer, int bufwidth, int c);
	void		(*bfont_draw_str)(uint16 *buffer, int width, char *str);
} abi_video_t;


#endif	/* __KALLISTI_ABI_VIDEO_H */
