/* KallistiOS 0.6

   kallisti/fs.h
   (c)2000 Dan Potter

   $Id: fs.h,v 1.3 2000/11/11 06:11:42 bard Exp $

*/

#ifndef __KALLISTI_FS_H
#define __KALLISTI_FS_H

#include <kallisti/stdtypes.h>
#include <kallisti/limits.h>

/* Directory entry; all handlers must conform to this interface */
typedef struct {
	int	size;
	char	name[MAX_FN_LEN];
	uint32	time;
	uint32	attr;
} dirent_t;

/* Handler interface; all VFS handlers must implement this interface. */
typedef struct {
	int	pid;	/* Process table ID for handler (0 == static) */
	int	cache;	/* Allow VFS cacheing; 0=no, 1=yes */

	uint32	(*open)(const char *fn, int mode);
	void	(*close)(uint32 hnd);
	ssize_t	(*read)(uint32 hnd, void *buffer, size_t cnt);
	ssize_t	(*write)(uint32 hnd, void *buffer, size_t cnt);
	off_t	(*seek)(uint32 hnd, off_t offset, int whence);
	off_t	(*tell)(uint32 hnd);		/* like ftell() */
	size_t	(*total)(uint32 hnd);		/* total file size */
	dirent_t* (*readdir)(uint32 hnd);	/* Directories and files are the same here */
	int	(*ioctl)(uint32 hnd, void *data, size_t size);	/* Device-specific call */
	int	(*rename)(const char *fn1, const char *fn2);	/* Rename and move files */
	int	(*unlink)(const char *fn);			/* Delete files */
} vfs_handler;


/* Open modes */
#define O_RDONLY	1		/* Read only */
#define O_RDWR		2		/* Read-write */
#define O_APPEND	3		/* Append to an existing file */
#define O_WRONLY	4		/* Write-only */
#define O_MODE_MASK	7		/* Mask for mode numbers */
#define O_DIR		0x1000		/* Open as directory */
#define O_META		0x2000		/* Open as metadata */

/* Seek modes */
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2


/* Standard file functions */
uint32	fs_open(char *fn, int mode);
void	fs_close(uint32 hnd);
ssize_t	fs_read(uint32 hnd, void *buffer, size_t cnt);
ssize_t	fs_write(uint32 hnd, void *buffer, size_t cnt);
off_t	fs_seek(uint32 hnd, off_t offset, int whence);
off_t	fs_tell(uint32 hnd);
size_t	fs_total(uint32 hnd);
dirent_t* fs_readdir(uint32 hnd);
int	fs_ioctl(uint32 hnd, void *data, size_t size);
int	fs_rename(const char *fn1, const char *fn2);
int	fs_unlink(const char *fn);

/* Add/Remove a VFS module */
int	fs_handler_add(char *prefix, vfs_handler *hnd);
int	fs_handler_remove(vfs_handler *hnd);

/* VFS init */
int	fs_init();

#endif	/* __KALLISTI_FS_H */

