/* KallistiOS 0.6

   kallisti/fs/iso9660.h
   (c)2000 Dan Potter

   $Id: iso9660.h,v 1.4 2000/11/09 04:41:02 bard Exp $
*/

#ifndef __KALLISTI_FS_ISO9660_H
#define __KALLISTI_FS_ISO9660_H

#include <kallisti/stdtypes.h>
#include <kallisti/limits.h>
#include <kallisti/fs.h>

#define MAX_ISO_FILES 8

/* Prototypes */
uint32	iso_open(const char *path, int flags);
void	iso_close(uint32 fd);
ssize_t	iso_read(uint32 fd, void *buf, size_t count);
off_t	iso_seek(uint32 fd, off_t offset, int whence);
off_t	iso_tell(uint32 fd);
size_t	iso_total(uint32 fd);

dirent_t *iso_readdir(uint32 fd);

int fs_iso9660_init();
int fs_iso9660_shutdown();


#endif	/* __KALLISTI_FS_ISO9660_H */
