/* KallistiOS 0.6

   fs/serconsole.h
   (c)2000 Dan Potter
   
   $Id: serconsole.h,v 1.2 2000/11/09 04:41:02 bard Exp $
*/

#ifndef __KALLISTI_FS_SERCONSOLE_H
#define __KALLISTI_FS_SERCONSOLE_H

/* Definitions for the "serial console" file system */

#include <kallisti/limits.h>
#include <kallisti/fs.h>

/* Printk replacement */
void fscc_printk(char *str);

/* File functions */
uint32	fscc_open(const char *fn, int mode);
void	fscc_close(uint32 hnd);
ssize_t	fscc_read(uint32 hnd, void *buf, size_t cnt);
off_t	fscc_seek(uint32 hnd, off_t offset, int whence);
off_t	fscc_tell(uint32 hnd);
size_t	fscc_total(uint32 hnd);

/* Init func */
int fs_serconsole_init();
int fs_serconsole_shutdown();

#endif	/* __KALLISTI_FS_SERCONSOLE_H */


