/* KallistiOS 0.6

   kallisti/irq.h
   (c)2000 Dan Potter

   $Id: irq.h,v 1.2 2000/11/09 04:41:02 bard Exp $ 
  
*/

#ifndef __KALLISTI_IRQ_H
#define __KALLISTI_IRQ_H

#include <kallisti/stdtypes.h>

/* The number of bytes required to save thread context. This should
   include all general CPU registers, FP registers, and status regs. */
#define REG_BYTE_CNT 256	/* Currently really 224 */

/* Various exception codes.. use these when getting or setting an
   exception code value. */

/* Reset type */
#define EXC_RESET_POWERON	0x0000	/* Power-on reset */
#define EXC_RESET_MANUAL	0x0020	/* Manual reset */
#define EXC_RESET_UDI		0x0000	/* Hitachi UDI reset */
#define EXC_ITLB_MULTIPLE	0x0140	/* Instruction TLB multiple hit */
#define EXC_DTLB_MULTIPLE	0x0140	/* Data TLB multiple hit */

/* Re-Execution type */
#define EXC_USER_BREAK_PRE	0x01e0	/* User break before instruction */
#define EXC_INSTR_ADDRESS	0x00e0	/* Instruction address */
#define EXC_ITLB_MISS		0x00a0	/* Instruction TLB miss */
#define EXC_ITLB_PV		0x00a0	/* Instruction TLB protection violation */
#define EXC_ILLEGAL_INSTR	0x0180	/* Illegal instruction */
#define EXC_GENERAL_FPU		0x0800	/* General FPU exception */
#define EXC_SLOT_FPU		0x0820	/* Slot FPU exception */
#define EXC_DATA_ADDRESS_READ	0x00e0	/* Data address (read) */
#define EXC_DATA_ADDRESS_WRITE	0x0100	/* Data address (write) */
#define EXC_DTLB_MISS_READ	0x0040	/* Data TLB miss (read) */
#define EXC_DTLB_MISS_WRITE	0x0060	/* Data TLB miss (write) */
#define EXC_DTLB_PV_READ	0x00a0	/* Data TLB P.V. (read) */
#define EXC_DTLB_PV_WRITE	0x00c0	/* Data TLB P.V. (write) */
#define EXC_FPU			0x0120	/* FPU exception */
#define EXC_INITIAL_PAGE_WRITE	0x0120	/* Initial page write exception */

/* Completion type */
#define EXC_TRAPA		0x0160	/* Unconditional trap */
#define EXC_USER_BREAK_POST	0x01e0	/* User break after instruction */

/* Interrupt (completion type) */
#define EXC_IRQ0		0x0200	/* External IRL requests */
#define EXC_IRQ1		0x0220
#define EXC_IRQ2		0x0240
#define EXC_IRQ3		0x0260
#define EXC_IRQ4		0x0280
#define EXC_IRQ5		0x02a0
#define EXC_IRQ6		0x02c0
#define EXC_IRQ7		0x02e0
#define EXC_IRQ8		0x0300
#define EXC_IRQ9		0x0320
#define EXC_IRQA		0x0340
#define EXC_IRQB		0x0360
#define EXC_IRQC		0x0380
#define EXC_IRQD		0x03a0
#define EXC_IRQE		0x03c0
#define EXC_TMU0_TUNI0		0x0400	/* TMU0 underflow */
#define EXC_TMU1_TUNI1		0x0420	/* TMU1 underflow */
#define EXC_TMU2_TUNI2		0x0440	/* TMU2 underflow */
#define EXC_TMU2_TICPI2		0x0460	/* TMU2 input capture */
#define EXC_RTC_ATI		0x0480
#define EXC_RTC_PRI		0x04a0
#define EXC_RTC_CUI		0x04c0
#define EXC_SCI_ERI		0x04e0	/* SCI Error receive */
#define EXC_SCI_RXI		0x0500	/* Receive ready */
#define EXC_SCI_TXI		0x0520	/* Transmit ready */
#define EXC_SCI_TEI		0x0540	/* Transmit error */
#define EXC_WDT_ITI		0x0560	/* Watchdog timer */
#define EXC_REF_RCMI		0x0580
#define EXC_REF_ROVI		0x05a0
#define EXC_UDI			0x0600	/* Hitachi UDI */
#define EXC_GPIO_GPIOI		0x0620
#define EXC_DMAC_DMTE0		0x0640
#define EXC_DMAC_DMTE1		0x0660
#define EXC_DMAC_DMTE2		0x0680
#define EXC_DMAC_DMTE3		0x06a0
#define EXC_DMA_DMAE		0x06c0
#define EXC_SCIF_ERI		0x0700	/* SCIF Error receive */
#define EXC_SCIF_RXI		0x0720
#define EXC_SCIF_BRI		0x0740
#define EXC_SCIF_TXI		0x0760

/* The following are a table of "type offsets" (see the Hitachi PDF).
   These are the 0x000, 0x100, 0x400, and 0x600 offsets. */
#define EXC_OFFSET_000		0
#define EXC_OFFSET_100		1
#define EXC_OFFSET_400		2
#define EXC_OFFSET_600		3

/* The type of an exception handler */
typedef void (*exc_handler)(uint32 offset, uint32 code);

/* Global timer count (rate is HZ per second (see config.h)). This
   value can be reset but it is not recommended if you enjoy the
   healthy status of the running kernel. */
extern volatile uint32 jiffies;

/* Set a handler, or remove a handler (see codes above); handler
   functions have one parameter, which is the exception code. */
int irq_set_handler(uint32 code, exc_handler hnd);

/* Set a global exception handler */
int irq_set_global_handler(exc_handler hnd);

/* Change register banks */
void irq_change_context(void *regbank);

/* Enable/Disable interrupts */
void irq_disable();
void irq_enable();

/* Init routine */
void irq_init();

/* Shutdown */
void irq_shutdown();

#endif	/* __KALLISTI_IRQ_H */

