/* KallistiOS 0.6

   kallisti/serial.h
   (c)2000 Dan Potter

   $Id: serial.h,v 1.4 2000/11/11 08:40:32 bard Exp $ 
  
*/

#ifndef __KALLISTI_SERIAL_H	/* heh */
#define __KALLISTI_SERIAL_H

#include <kallisti/stdtypes.h>

/* Initialize the SCIF port; baud_rate must be at least 9600 and
   no more than 57600. 115200 does NOT work for most PCs. */
void serial_init(int baud_rate, int fifo);

/* Write one char to the serial port (call serial_flush()!)*/
void serial_write(int c);

/* Flush all FIFO'd bytes out of the serial port buffer */
void serial_flush();

/* Send an entire buffer */
void serial_write_buffer(uint8 *data, int len);

/* Read an entire buffer (block) */
void serial_read_buffer(uint8 *data, int len);

/* Send a string (null-terminated) */
void serial_write_str(char *str);

/* Read one char from the serial port (-1 if nothing to read) */
int serial_read();


/* From serial_buffer.c */

/* Program-level read */
int serbuf_read();

/* Program-level block-read */
void serbuf_read_buffer(uint8 *data, int len);

/* Initialze serial buffering */
int serbuf_init();

/* Shutdown serial buffering */
void serbuf_shutdown();




#endif	/* __KALLISTI_SERIAL_H */

