/* KallistiOS 0.6

   kallisti/spu.h
   (c)2000 Dan Potter

   $Id: spu.h,v 1.2 2000/11/09 04:41:02 bard Exp $

*/

#ifndef __KALLISTI_SPU_H
#define __KALLISTI_SPU_H

#include <kallisti/stdtypes.h>

/* Waits for the sound ram FIFO to empty */
void spu_ram_write_wait();

/* memcpy and memset designed for sound RAM; for addresses, don't
   bother to include the 0xa0800000 offset that is implied. 'length'
   must be a multiple of 4, but if it is not it will be rounded up. */
void spu_memload(uint32 to, uint8 *from, int length);
void spu_memset(uint32 to, uint32 what, int length);

/* Enable/disable the SPU; note that disable implies reset of the
   ARM CPU core. */
void spu_enable();
void spu_disable();

/* Initialize the SPU; by default it will be left in a state of
   reset until you upload a program. */
int spu_init();

/* Shutdown SPU */
int spu_shutdown();

#endif	/* __KALLISTI_SPU_H */
