/* KallistiOS 0.6

   kallisti/thread.h
   (c)2000 Dan Potter

   $Id: thread.h,v 1.2 2000/11/09 04:41:02 bard Exp $

*/

#ifndef __KALLISTI_THREAD_H
#define __KALLISTI_THREAD_H

#include <kallisti/stdtypes.h>
#include <kallisti/irq.h>

/* Thread stack size -- each thread gets this much stack */
#define THD_STACK_SIZE 16384

/* Structure describing one running thread */
typedef struct kthread_str {
	/* Thread id -- same as process id for now */
	uint32	tid;
	
	/* Flags */
	uint32	flags;

	/* Next scheduled tick; used for thread sleep operations; zero
	   means no blocking. */
	uint32	next_jiffy;

	/* Register store; used to save thread context */
	uint32	context[REG_BYTE_CNT / 4];

	/* Thread private stack; all threads get the same for now */
	uint32	stack[THD_STACK_SIZE/4];

	/* Link to next thread */
	struct kthread_str *next;
} kthread_t;

/* Thread mutex: right now it's just a flag */
typedef int thd_mutex_t;
#define THD_MUTEX_INITIALIZER 0

/* Thread event: right now it's just a flag */
typedef int thd_event_t;
#define THD_EVENT_INITIALIZER 0

/* Thread flag values */
#define THD_DEFAULTS	0	/* Defaults: no flags */
#define THD_DEAD	1	/* Thread is awaiting death */
#define THD_USER	2	/* Thread runs in user mode */

/* Are threads enabled? */
extern int thd_enabled;

/* Next available thread id */
extern uint32 thd_next_id;

/* New thread function; given a routine address, it will create a
   new kernel thread with a default 4k stack. When the routine
   returns, the thread will exit. Returns the new thread id. */
uint32 thd_create(void (*routine)(void *param), void *param);

/* Given a thread id, this function removes the thread from
   the execution chain. */
int thd_destroy(uint32 tid);

/* Execute within a thread's timeslice to voluntarily give up
   the current timeslice. */
void thd_pass();

/* Thread blocking based sleeping; this is the preferred way to
   sleep because it eases the load on the system for the other
   threads. */
void thd_sleep_jiffies(uint32 jif);
void thd_sleep(uint32 ms);

/* Mutex lock/unlock */
void thd_mutex_reset(volatile thd_mutex_t *mutex);
void thd_mutex_lock(volatile thd_mutex_t *mutex);
void thd_mutex_unlock(volatile thd_mutex_t *mutex);

/* Event trigger/wait */
void thd_event_reset(volatile thd_event_t *event);
void thd_event_set(volatile thd_event_t *event);
void thd_event_wait(volatile thd_event_t *event);

/* Enable/disable threading temporarily */
void thd_enable(int old);
int thd_disable();

/* Get jiffies count */
uint32 thd_jiffies();

/* Init */
int thd_init();

/* Shutdown */
int thd_shutdown();


#endif	/* __KALLISTI_THREAD_H */



