/* KallistiOS 0.6

   kallisti/timer.h
   (c)2000 Dan Potter

   $Id: timer.h,v 1.2 2000/11/09 04:41:02 bard Exp $

*/

#ifndef __KALLISTI_TIMER_H
#define __KALLISTI_TIMER_H

/* Timer sources -- we get four on the SH4 */
#define TMU0	0	/* Off limits during normal operation */
#define TMU1	1	/* Available */
#define TMU2	2	/* Available */
#define WDT	3	/* Not supported yet */

/* Pre-initialize a timer; set values but don't start it */
int timer_prime(int which, uint32 speed, int interrupts);

/* Start a timer -- starts it running (and interrupts if applicable) */
int timer_start(int which);

/* Stop a timer -- and disables its interrupt */
int timer_stop(int which);

/* Returns the count value of a timer */
uint32 timer_count(int which);

/* Clears the timer underflow bit and returns what its value was */
int timer_clear(int which);

/* Kernel spin-lock sleep function; this should only be used inside the
   kernel and it will only function correctly if TMU0 is left ticking at
   the value in HZ. It's accurate to 1/HZ seconds. */
void timer_sleep(int ms);

/* Sleep a certain number of jiffies; this only works if you left TMU0
   running, but it is not speed dependent. */
void timer_sleep_jiffies(int jifs);

/* Spin-loop kernel sleep func: more accurate than the
   normal one because it uses a timer instead of waiting for the
   next interrupt on TMU0. Also works whether interrupts are enabled
   or whatever. Uses timer 1 by default. */
void timer_spin_sleep(int ms);

/* Enable timer interrupts (high priority); needs to move
   to irq.c sometime. */
void timer_enable_ints(int which);

/* Disable timer interrupts; needs to move to irq.c sometime. */
void timer_disable_ints(int which);

/* Check whether ints are enabled */
int timer_ints_enabled(int which);


/* Init function */
int timer_init();

/* Shutdown */
void timer_shutdown();


#endif	/* __KALLISTI_TIMER_H */

