/* KallistiOS 0.6

   kallisti/video.h
   (c)2000 Dan Potter

   $Id: video.h,v 1.3 2000/11/12 01:06:49 bard Exp $

*/

#ifndef __KALLISTI_VIDEO_H
#define __KALLISTI_VIDEO_H

#include <kallisti/stdtypes.h>

extern uint32 *vram_l;
extern uint16 *vram_s;
extern int vram_config;
extern int vram_size;

#define CT_VGA		0
#define CT_RGB		2
#define CT_COMPOSITE	3
int vid_check_cable();

#define PM_RGB555	0
#define PM_RGB565	1
#define PM_RGB888	3
#define DM_320x240	0
#define DM_640x480	1
#define DM_800x608	2	/* experimental */
void vid_set_mode(int cable_type, int video_mode, int pixel_mode);

void vid_set_start(uint32 start);
void vid_border_color(int r, int g, int b);
void vid_clear(int r, int g, int b);
void vid_empty();
void vid_waitvbl();

void vid_init(int video_mode, int pixel_mode);
void vid_shutdown();

#endif	/* __KALLISTI_VIDEO_H */
