/* KallistiOS 0.6

   string.h
   (c)2000 Dan Potter

   $Id: string.h,v 1.3 2000/11/09 04:43:36 bard Exp $

*/

#ifndef __STRING_H
#define __STRING_H

#include <unistd.h>

void   bcopy(const void * src, void * dest, size_t count);
char * index(const char *p, const char *ch);
void * memchr(const void *s, uint8 c, size_t n);
int    memcmp(const void * cs,const void * ct,size_t count);
void * memcpy(void * dest,const void *src,size_t count);
void * memcpy4(void * dest,const void *src,size_t count);
void * memmove(void * dest,const void *src,size_t count);
void * memset(void * s,int c,size_t count);
void * memset4(void * s,unsigned long c,size_t count);
void * memscan(void * addr, int c, size_t size);
char * rindex(const char *p, const char *ch);
char * strcat(char * dest, const char * src);
char * strchr(const char * s, int c);
int    strcmp(const char * cs,const char * ct);
char * strcpy(char * dest,const char *src);
int    stricmp(const char *cs, const char *ct);
size_t strlen(const char * s);
char * strncat(char *dest, const char *src, size_t count);
char * strncpy(char * dest,const char *src, size_t count);
int    strnicmp(const char *cs, const char *ct, int cnt);
int    strncmp(const char * cs,const char * ct,size_t count);
size_t strnlen(const char * s, size_t count);
char * strpbrk(const char * cs,const char * ct);
char * strrchr(const char * s, int c);
char * strsep(char **stringp, const char *delim);
size_t strspn(const char *s, const char *accept);
char * strstr(const char * s1,const char * s2);
char * strtok(char * s,const char * ct);


#endif	/* __STRING_H */
