/* KallistiOS 0.6

   main.c
   (c)2000 Dan Potter

*/

static char id[] = "KOS $Id: main.c,v 1.3 2000/11/09 04:49:40 bard Exp $";

/* When using KallistiOS in a standalone mode, this file and its peers
   in this directory make up the "main" of the kernel library. */

#include <stdio.h>
#include <kallisti/fs/builtin.h>
#include <kallisti/fs/iso9660.h>
#include <kallisti/fs/vmu.h>
#include <kallisti/fs/serconsole.h>
#include <kallisti/process.h>

#include <kallisti/maple.h>
#include <kallisti/controller.h>
#include <kallisti/keyboard.h>

/* An ELF program to run by default */
#include "elfprog.h"

/* A small example built-in table */
fs_builtin_ent bitab = {
	"/init.elf",
	(uint8*)elfprog,
	sizeof(elfprog)
};
#define BITAB_SIZE 1

/* Initialize the VMU apple icon */
#include "vmu_icon.h"
void vmu_icon_init() {
	uint8 bitmap[48*32/8] = {0};
	int x, y, xi, xb;
	
	for (y=0; y<32; y++)
		for (x=0; x<48; x++) {
			xi = x / 8;
			xb = 0x80 >> (x % 8);
			if (vmu_icon[(31-y)*48+(47-x)] == '.')
				bitmap[y*(48/8)+xi] |= xb;
		}
	
	vmu_draw_lcd(maple_first_vmu(), bitmap);
}

int main() {
	/* serial_disable(); */
	// fs_serconsole_init();

	printf("KallistiOS 1.0 Booting\r\n");
	malloc_stats();

	/* Init maple bus */
	printf("init maple bus\r\n");
	maple_init();
	vmu_icon_init();

	/* Enable threads */
	printf("init threads\r\n");
	thd_init();

	/* Init process stuff */
	printf("init ps\r\n");
	ps_init();

	/* Enable TA */
	printf("init ta\r\n");
	ta_init();

	/* Initialize the built-in file system */
	printf("init bi file system\r\n");
	fs_builtin_init();
	fs_builtin_set_table(&bitab, BITAB_SIZE);

	/* Initialize the ISO9660 file system */
	printf("init iso filesystem\r\n");
	fs_iso9660_init();
	
	/* Initialize the VMU file system */
	printf("init vmu filesystem\r\n");
	fs_vmu_init();

	/* Start a new loaded process */
	ps_load_and_exec("/bi/init.elf", 0, NULL);
	
	printf("jiffies are %d\r\n", jiffies);

	/* Shutdown ps */
	ps_shutdown();

	/* Disable threads */
	thd_shutdown();

	printf("shutdown ta\r\n");
	ta_shutdown();

	printf("shutdown builtin\r\n");
	fs_builtin_shutdown();
	printf("shutdown iso9660\r\n");
	fs_iso9660_shutdown();
	printf("shutdown vmu\r\n");
	fs_vmu_shutdown();
	
	printf("shutdown maple\r\n");
	maple_shutdown();

	printf("KallistiOS Exit.\r\n");
	malloc_stats();
	
	// fs_serconsole_shutdown();
	
	return 0;
}



