/* KallistiOS 0.6

   main.c
   (c)2000 Dan Potter
*/

static char id[] = "KOS $Id: main.c,v 1.2 2000/11/09 05:00:09 bard Exp $";

extern int _bss_start, end;

/* Setup basic kernel services (printf, etc) */
#include <stdio.h>
#include <malloc.h>
#include <kallisti/abi/fundamental.h>
static abi_fundamental_t fabi;
void basic_svc_init() {
	memset(&fabi, 0, sizeof(fabi));

	/* Fundamental ABI Version 1.0.0 */	
	fabi.hdr.version = ABI_MAKE_VER(1, 0, 0);
	
	fabi.printf = printf;
	
	fabi.malloc = malloc;
	fabi.free = free;
	fabi.memalign = memalign;
	
	svcmpx_add_handler("fundamental", &fabi);
}

/* This is the entry point inside the C program */
int kernel_main() {
	unsigned char *bss_start = (unsigned char *)(&_bss_start);
	unsigned char *bss_end = (unsigned char *)(&end);
	int rv;

	/* Clear out the BSS area */
	memset(bss_start, 0, bss_end - bss_start);

	/* Call kernel init functions */
	mm_init();		/* Memory manager */
	svcmpx_init();		/* Service multiplexer */
	basic_svc_init();	/* Basic services */
	hardware_init();	/* Hardware */
	fs_init();		/* VFS */

	/* Call the user's main function */
	rv = main();

	/* Shut down kernel functions */
	hardware_shutdown();

	return rv;
}


/* When you make a function called main() in a GCC program, it wants
   this stuff too. */
void _main() { }
void atexit() { }

