! KallistiOS 0.6
!
! startup.s
! (c)2000 Dan Potter
!
! This file must appear FIRST in your linking order, or your program won't
! work correctly as a raw binary.
!
! This is designed as a replacement for "crt0", but "crt0" is a more
! appropriate name for a program running under an OS, so I've renamed it
! to startup.s.
!
! This is very loosely based on Marcus' crt0.s/startup.s
!

.globl start

start:
	! Disable interrupts (if they're enabled)
	stc	sr, r0
	or	#0xf0, r0
	ldc	r0, sr

	! Run in the P2 area
	mov.l	setup_cache_addr,r0
	mov.l	p2_mask,r1
	or	r1,r0
	jmp	@r0
	nop

setup_cache:
	! Now that we are in P2, it's safe to enable the cache
	mov.l	ccr_addr,r0
	mov.w	ccr_data,r1
	mov.l	r1,@r0

	! After changing CCR, eight instructions must be executed before
	! it's safe to enter a cached area such as P1
	mov.l	init_addr,r0	! 1
	mov	#0,r1		! 2
	nop			! 3
	nop			! 4
	nop			! 5
	nop			! 6
	nop			! 7
	nop			! 8
	jmp	@r0		! go
	mov	r1,r0
	nop

init:
	! Save the current stack, and set a new stack (higher up in RAM)
	mov.l	old_stack_addr,r0
	mov.l	r15,@r0
	mov.l	new_stack,r15

	! Jump to the kernel main
	mov.l	main_addr,r0
	sts.l	pr,@-r15
	jsr	@r0
	nop
	lds.l	@r15+,pr

	! Re-disable interrupts (just in case)
	stc	sr,r0
	or	#0xf0,r0
	ldc	r0,sr

	! Set back the stack and return (presumably to a serial debug)
	mov.l	old_stack,r15
	rts
	nop

! Misc variables
	.align	4
old_stack_addr:
	.long	old_stack + 0x20000000
old_stack:
	.long	0
new_stack:
	.long	0x8d000000
p2_mask:
	.long	0xa0000000
setup_cache_addr:
	.long	setup_cache
init_addr:
	.long	init
main_addr:
	.long	_kernel_main
ccr_addr:
	.long	0xff00001c
ccr_data:
	.word	0x090d

	.ascii  "KOS $Id: startup.s,v 1.2 2000/11/09 05:00:09 bard Exp $"

