/* KallistiOS 0.6

   memcpy4.c
   (c)2000 Dan Potter

   $Id: memcpy4.c,v 1.3 2000/11/12 01:14:51 bard Exp $
*/

#include <string.h>

/* This variant was added by Dan Potter for its usefulness in 
   working with Dreamcast external hardware. */
void * memcpy4(void *dest, const void *src, size_t count)
{
	unsigned long *tmp = (unsigned long *) dest;
	unsigned long *s = (unsigned long *) src;
	count = count/4;

	while (count--)
		*tmp++ = *s++;

	return dest;
}
