/* KallistiOS 0.6

   printf.c
   (c)2000 Dan Potter
*/

#include <stdio.h>
#include <stdarg.h>
#include <kallisti/process.h>
#include <kallisti/thread.h>

/* Not re-entrant */
static char printf_buf[1024];
static thd_mutex_t mutex = THD_MUTEX_INITIALIZER;

int printf(const char *fmt, ...) {
	va_list args;
	int i;

	thd_mutex_lock(&mutex);
	va_start(args, fmt);
	i = vsprintf(printf_buf, fmt, args);
	va_end(args);

	ps_printk(printf_buf);

	thd_mutex_unlock(&mutex);
	return i;
}

/* We can't really do this, but a lot of programs do things like this:

   fprintf(stderr, ...);

   This is most easily supported by faking the call and doing a normal
   printf() instead. */
/* int fprintf(FILE *f, const char *fmt, ...) {
	va_list args;
	int i;

	thd_mutex_lock(&mutex);
	va_start(args, fmt);
	i = vsprintf(printf_buf, fmt, args);
	va_end(args);

	serial_write_str(printf_buf);

	thd_mutex_unlock(&mutex);
	return i;
} */


