/* KallistiOS 0.6

   event.c
   (c)2000 Dan Potter

*/

static char id[] = "KOS $Id: event.c,v 1.1 2000/11/09 05:18:38 bard Exp $";

#include "jam.h"

/* Translate an event to the given window */
int jam_event_translate(jam_window_t *wnd, jam_event_t *evt) {
	evt->x -= wnd->x1;
	evt->y -= wnd->y1;
	return 0;
}

/* Synthesize an event on the given window */
int jam_event_synth(jam_window_t *wnd, jam_event_t *evt) {
	if (evt->x < 0 || evt->y < 0 || evt->x > wnd->w || evt->y > wnd->h) {
		if (jam_mgr)
			jam_mgr->decor_event(wnd, evt);
	} else if (wnd->event)
		return wnd->event(wnd, evt);
	else
		return 0;
}

