/* KallistiOS 0.6

   input.c
   (c)2000 Dan Potter

*/

static char id[] = "KOS $Id: input.c,v 1.2 2000/11/11 04:56:34 bard Exp $";

#include "jam.h"

/* Cursor location */
int jam_ptr_x, jam_ptr_y, ptr_moved;

/* Button status */
typedef struct {
	uint8		down;
	uint8		pressed;
	uint8		released;
	uint8		translation;
} btnstat_t;
#define B_CONT_A	0
#define B_CONT_B	1
#define B_CONT_X	2
#define B_CONT_Y	3
#define B_MOUSE_L	4
#define B_MOUSE_R	5
#define B_MOUSE_S	6
#define B_CNT		7
btnstat_t buttons[B_CNT] = { {0, 0, 0, 0} };

/* Window the input is locked to (if any) */
static jam_window_t *lock_wnd = NULL;

/* Lock the input to the given window */
int jam_input_lock(jam_window_t *owner) {
	if (lock_wnd)
		return -1;
	else {
		lock_wnd = owner;
		return 0;
	}
}

/* Free the input */
int jam_input_unlock() {
	if (!lock_wnd)
		return -1;
	else {
		lock_wnd = NULL;
		return 0;
	}
}

/* Poll the controller and use the analog joystick input */
static int poll_controller() {
	cont_cond_t ccond;
	btnstat_t *cur;
	int to = 5;

	/* Get controller status */	
	while (maple->cont_get_cond(maple->first_controller(), &ccond) < 0) {
		printf("Error getting controller status\r\n");
		if (to-- <= 0)
			return -1;
		thd->sleep(10);
	}

	/* If they hit start, then exit */
	if (!(ccond.buttons & CONT_START))
		return -1;

	/* Move the mouse pointer if neccessary */
	if (ccond.joyx != 128 || ccond.joyy != 128) {
		int jx = ccond.joyx, jy = ccond.joyy;

		jam_ptr_x += (jx - 128)/8;
		jam_ptr_y += (jy - 128)/8;
		ptr_moved = 1;
	}
	
	/* Check A btn */
	cur = buttons + B_CONT_A;
	if (!cur->down && !(ccond.buttons & CONT_A)) {
		cur->down = 1;
		cur->pressed = 1;
	} else if (cur->down && (ccond.buttons & CONT_A)) {
		cur->down = 0;
		cur->released = 1;
	}

	return 0;
}

/* Poll the mouse and apply cursor acceleration */
static int mouse_accel[] = {
	0,0,0,1,2,4,5,6,7,7,8,8,9,9,9,10,10,10,11,11,11,11,11,
	12,12,12,12,12,13,13,13,13,13,13,13,13,14,14,14,
	14,14,14,14,14,14,15,15,15,15,15,15,15,15,15,15,
	15,15,16,16,16,16,16,16
};
static int poll_mouse() {
	mouse_cond_t mcond;
	btnstat_t *cur;
	int to = 5;

	/* Get mouse status */
	while (maple->mouse_get_cond(maple->first_mouse(), &mcond) < 0) {
		printf("Error getting mouse status\r\n");
		if (to-- <= 0)
			return -1;
		thd->sleep(10);
	}

	/* Move the mouse pointer if neccessary */
	if (mcond.dx || mcond.dy) {
		int dx = mcond.dx, dy = mcond.dy;

		if (dx < 0)
			jam_ptr_x -= -dx + mouse_accel[-dx];
		else
			jam_ptr_x += dx + mouse_accel[dx];

		if (dy < 0)
			jam_ptr_y -= -dy + mouse_accel[-dy];
		else
			jam_ptr_y += dy + mouse_accel[dy];
			
		ptr_moved = 1;
	}

	/* Check left btn */
	cur = buttons + B_MOUSE_L;
	if (!cur->down && !(mcond.buttons & MOUSE_LEFTBUTTON)) {
		cur->down = 1;
		cur->pressed = 1;
	} else if (cur->down && (mcond.buttons & MOUSE_LEFTBUTTON)) {
		cur->down = 0;
		cur->released = 1;
	}

	
	return 0;
}


static int last_check = -1;
int jam_input_check() {
	int i;
	jam_window_t *wnd;

	/* Make sure we don't flood maple */
	if (last_check == thd->jiffies())
		return 0;
	last_check = thd->jiffies();

	/* Check all maple inputs */
	if (poll_controller() < 0)
		return -1;
	if (poll_mouse() < 0)
		return -1;

	/* Move the mouse pointer if neccessary */
	if (ptr_moved) {
		/* Check mouse bounds */
		if (jam_ptr_x < 0) jam_ptr_x = 0;
		if (jam_ptr_x > 639) jam_ptr_x = 639;
		if (jam_ptr_y < 0) jam_ptr_y = 0;
		if (jam_ptr_y > 479) jam_ptr_y = 479;
		
		/* If it was in a window, send the event on */
		if (lock_wnd)
			wnd = lock_wnd;
		else
			wnd = jam_win_find_event(jam_ptr_x, jam_ptr_y);
		if (wnd != NULL) {
			jam_event_t event = { JAM_EVT_CURSORMOVE, jam_ptr_x, jam_ptr_y };
			jam_event_translate(wnd, &event);
			jam_event_synth(wnd, &event);
		}
		
		ptr_moved = 0;
	}

	/* If they pushed or released button, generate an event */
	for (i=0; i<B_CNT; i++) {
		if (buttons[i].pressed) {
			if (lock_wnd)
				wnd = lock_wnd;
			else
				wnd = jam_win_find_event(jam_ptr_x, jam_ptr_y);
			if (wnd != NULL) {
				jam_event_t event = { JAM_EVT_BTNPRESS, jam_ptr_x, jam_ptr_y,
					buttons[i].translation+JAM_BTN_FIRST };
				jam_event_translate(wnd, &event);
				jam_event_synth(wnd, &event);
			}
			buttons[i].pressed = 0;
		}
	
		if (buttons[i].released) {
			if (lock_wnd)
				wnd = lock_wnd;
			else
				wnd = jam_win_find_event(jam_ptr_x, jam_ptr_y);
			if (wnd != NULL) {
				jam_event_t event = { JAM_EVT_BTNRELEASE, jam_ptr_x, jam_ptr_y,
					buttons[i].translation+JAM_BTN_FIRST };
				jam_event_translate(wnd, &event);
				jam_event_synth(wnd, &event);
			}
			buttons[i].released = 0;
		}
	}
	
	return 0;
}

/* The main maple loop */
void jam_input_loop() {
	int i, jif1;

	printf("Inside input loop\r\n");

	jam_ptr_x = 320;
	jam_ptr_y = 240;
	ptr_moved = 0;
	
	for (i=0; i<B_CNT; i++) {
		buttons[i].down = buttons[i].pressed = buttons[i].released = 0;
	}
	buttons[B_CONT_A].translation = JAM_BTN_1 - JAM_BTN_FIRST;
	buttons[B_CONT_X].translation = JAM_BTN_2 - JAM_BTN_FIRST;
	buttons[B_CONT_B].translation = JAM_BTN_3 - JAM_BTN_FIRST;
	buttons[B_CONT_Y].translation = JAM_BTN_4 - JAM_BTN_FIRST;
	buttons[B_MOUSE_L].translation = JAM_BTN_1 - JAM_BTN_FIRST;
	buttons[B_MOUSE_R].translation = JAM_BTN_3 - JAM_BTN_FIRST;
	buttons[B_MOUSE_S].translation = JAM_BTN_2 - JAM_BTN_FIRST;
	
	/* Check input */
	while(1) {
		/* Check for input and update counters */
		jif1 = thd->jiffies();
		if (jam_input_check()) break;
		
		/* Throw away the rest of our thread cycle if we
		   didn't already run over */
		if (thd->jiffies() == jif1) thd->pass();
	}
	
	/* Tell JAM to exit */
	jam_exit_flag = 1;
}

