/* KallistiOS 0.6

   jam.c
   (c)2000 Dan Potter

*/

static char id[] = "KOS $Id: jam.c,v 1.1 2000/11/09 05:18:38 bard Exp $";


#include <malloc.h>

#include <kallisti/libk.h>
#include "jam.h"

/*

This module handles the GUI system (JAM). It's designed to be loaded
as a user program.

*/

/* KallistiOS interfaces */
abi_thread_t *thd = NULL;
abi_maple_t *maple = NULL;
abi_ta_t *ta = NULL;
abi_video_t *video = NULL;


/* Exit Flag */
volatile int jam_exit_flag;

/* Window Manager (if any) */
jam_window_manager_t *jam_mgr = NULL;

/* Set a window manager */
int jam_set_window_manager(jam_window_manager_t *mgr) {
	jam_mgr = mgr;
	return 0;
}


/* A little texture allocation function: right now I'm still not totally
   sure what we can overwrite in the TA buffers ^_^;; so we start allocating
   at a safe space. This doesn't leave much actual texture space (2 megs) but
   it's enough for now. Also there is no way to free texture ram right now. */
static uint32 texture_pool = 0x400000;
uint32 jam_texture_alloc(uint32 size) {
	uint32 rv = texture_pool;

	/* Align to 8 bytes */	
	size = (size + 7) & (~7);
	texture_pool += size;
	
	printf("Allocating texture at %08x\r\n", rv);
	return rv;
}


/* Creates the utility texture used in JAM for the
   font and mouse cursor. The resulting texture will
   be 256x256. */
#include "mouse1.h"
uint32 util_texture = 0;
static void jam_setup_textures() {
	volatile uint16 *vram;
	int x, y;
	
	util_texture = jam_texture_alloc(256*256*2);
	vram = (uint16*)ta->texture_map(util_texture);

	printf("Writing util texture to %08x\r\n", vram);
	
	/* First dump in the mouse cursor */
	for (y=0; y<16; y++) {
		for (x=0; x<10; x++) {
			if (mouse1_xpm[y*10+x] == '.')
				*vram = 0xffff;
			else if (mouse1_xpm[y*10+x] == '+')
				*vram = 0xf000;
			else
				*vram = 0x0000;
			vram++;
		}
		vram += 256 - 10;
	}
	
	/* Now add the rest as ASCII characters */
	vram = (uint16*)ta->texture_map(util_texture);
	for (y=0; y<8; y++) {
		for (x=0; x<16; x++) {
			/* Skip the first (it's a mouse pointer) */
			if (x != 0 || y != 0) 
				video->bfont_draw(vram, 256, y*16+x);
			vram += 16;
		}
		vram += 23*256;
	}
}

void blit_font_texture() {
	vertex_ot_t vert;
	
	vert.flags = 0xe0000000;
	vert.x = 50.0f;
	vert.y = 50.0f + 256.0f;
	vert.z = 4.0f;
	vert.u = 0.0f;
	vert.v = 1.0f;
	vert.dummy1 = vert.dummy2 = 0;
	vert.a = 0.6f; vert.r = 1.0f; vert.g = 1.0f; vert.b = 1.0f;
	vert.oa = vert.or = vert.og = vert.ob = 0.0f;
	ta->commit_vertex(&vert, sizeof(vert));

	vert.x = 50.0f;
	vert.y = 50.0f;
	vert.u = 0.0f;
	vert.v = 0.0f;
	ta->commit_vertex(&vert, sizeof(vert));

	vert.x = 50.0f + 256.0f;
	vert.y = 50.0f + 256.0f;
	vert.u = 1.0f;
	vert.v = 1.0f;
	ta->commit_vertex(&vert, sizeof(vert));

	vert.flags = 0xe0000000 | 0x10000000;
	vert.x = 50.0f + 256.0f;
	vert.y = 50.0f;
	vert.u = 1.0f;
	vert.v = 0.0f;
	ta->commit_vertex(&vert, sizeof(vert));
	
	return;
}

void jam_ta_loop(void *param) {
	/* Initialize built-in window manager */
	printf("jam_wm_init()\r\n");
	jam_wm_init();

	/* Test program */
	printf("test_main()\r\n");
	test_main();

	/* JAM main loop */
	printf("entering main JAM loop\r\n");
	while(!jam_exit_flag) {
		//if (jam_input_check()) break;
		/* Do an output frame */
		jam_repaint();
	}
	
	printf("exiting main JAM loop\r\n");
}

// int jam_main(int argc, char **argv) {
int main(int argc, char **argv) {
	printf("JAM 1.0 initializing\r\n");

	/* Initialize ABIs */
	thd = lib_open("thread");
	if (!thd) { printf("Can't open thread library\r\n"); return -1; }
	maple = lib_open("maple");
	if (!maple) { printf("Can't open maple library\r\n"); return -1; }
	ta = lib_open("ta");
	if (!ta) { printf("Can't open ta library\r\n"); return -1; }
	video = lib_open("video");
	if (!video) { printf("Can't open video library\r\n"); return -1; }
	
	/* Initialize window data structures */
	jam_exit_flag = 0;
	jam_ptr_x = 320; jam_ptr_y = 240;
	jam_windows = NULL;
	thd->mutex_reset(&jam_windows_mutex);

	/* Create utility texture in VRAM */
	printf("jam_setup_textures()\r\n");
	jam_setup_textures();

	/* Start a maple thread */
	printf("thd->create(jam_input_loop)\r\n");
	if (thd->create(jam_input_loop, NULL) < 0)
		return -1;

	/* Start a ta thread */
	printf("thd->create(jam_ta_loop)\r\n");
	if (thd->create(jam_ta_loop, NULL) < 0)
		return -1;
	
	/* Wait until quit comes up. */
	while (!jam_exit_flag)
		thd->pass();
}





