/* KallistiOS 0.6

   repaint.c
   (c)2000 Dan Potter

*/

static char id[] = "KOS $Id: repaint.c,v 1.1 2000/11/09 05:18:38 bard Exp $";

#include <kallisti/ta.h>
#include "jam.h"

static void jam_draw_desktop() {
	static float shifty = 0.0f, sd = 0.01f;
	poly_hdr_t	poly;
	vertex_oc_t	vert;

	/* Start a colored polygon set */
	ta->poly_hdr_col(&poly, TA_OPAQUE);
	ta->commit_poly_hdr(&poly);
	
	vert.flags = TA_VERTEX_NORMAL;
	vert.x = 0.0f;
	vert.y = 480.0f;
	vert.z = 1.0f;
	vert.a = 1.0f;
	vert.r = 1.0f;
	vert.g = 1.0f - shifty;
	vert.b = 0.0f;
	ta->commit_vertex(&vert, sizeof(vert));
	
	vert.y = 0.0f;
	vert.r = 0.0f; vert.g = 1.0f;
	ta->commit_vertex(&vert, sizeof(vert));
	
	vert.x = 640.0f;
	vert.y = 480.0f;
	vert.g = 0.0f; vert.b = 1.0f;
	ta->commit_vertex(&vert, sizeof(vert));

	vert.flags = TA_VERTEX_EOL;
	vert.y = 0.0f;	
	vert.r = 1.0f; vert.g = shifty; vert.b = 0.0f;
	ta->commit_vertex(&vert, sizeof(vert));
	
	shifty += sd;
	if (shifty < 0.0f || shifty > 1.0f) {
		sd = -sd;
		shifty += sd;
	}
}

static int mouse_lx[4] = {-1, -1, -1, -1};
static int mouse_ly[4] = {0,0,0,0};
static void jam_draw_mouse_at(int ptrx, int ptry, float alpha) {
	vertex_ot_t	vert;
	
	vert.flags = TA_VERTEX_NORMAL;
	vert.x = ptrx;
	vert.y = ptry + 16.0f;
	vert.z = 1024.0f + alpha;
	vert.u = 0.0f;
	vert.v = 16.0f / 256.0f;
	vert.dummy1 = vert.dummy2 = 0;
	vert.a = alpha;
	vert.r = 1.0f;
	vert.g = 1.0f;
	vert.b = 1.0f;
	vert.oa = vert.or = vert.og = vert.ob = 0.0f;
	ta->commit_vertex(&vert, sizeof(vert));
	
	vert.x = ptrx;
	vert.y = ptry;
	vert.u = 0.0f;
	vert.v = 0.0f;
	ta->commit_vertex(&vert, sizeof(vert));
	
	vert.x = ptrx + 10.0f;
	vert.y = ptry + 16.0f;
	vert.u = 10.0f / 256.0f;
	vert.v = 16.0f / 256.0f;
	ta->commit_vertex(&vert, sizeof(vert));

	vert.flags = TA_VERTEX_EOL;
	vert.x = ptrx + 10.0f;
	vert.y = ptry;
	vert.u = 10.0f / 256.0f;
	vert.v = 0.0f;
	ta->commit_vertex(&vert, sizeof(vert));
}
/* Handles mouse trails */
static int trails_delay = 1;
static void jam_draw_mouse() {
	int i;
	float alpha[4] = {1.0f, 0.4f, 0.2f, 0.1f};
	poly_hdr_t	poly;
	static int shown = 0;
	
	if (trails_delay <= 0) {
		for (i=3; i>0; i--) {
			mouse_lx[i] = mouse_lx[i-1];
			mouse_ly[i] = mouse_ly[i-1];
		}
		trails_delay = 1;
	} else {
		trails_delay--;
	}
	mouse_lx[0] = jam_ptr_x;
	mouse_ly[0] = jam_ptr_y;

	if (!shown) {
		printf("Texture at %08x\r\n", util_texture);
		shown = 1;
	}
	
	/* Start a textured polygon set (with the font texture) */
	ta->poly_hdr_txr(&poly, TA_TRANSLUCENT, TA_ARGB4444, 256, 256,
		util_texture, TA_NO_FILTER);
	ta->commit_poly_hdr(&poly);

	for (i=0; i<4; i++) {
		jam_draw_mouse_at(mouse_lx[i], mouse_ly[i], alpha[i]);
	}
}


/* Draw one font character (12x24) */
void jam_draw_char(float x1, float y1, float z1, float a, float r,
		float g, float b, int c) {
	vertex_ot_t	vert;
	int ix = (c % 16) * 16;
	int iy = (c / 16) * 24;
	float u1 = ix * 1.0f / 256.0f;
	float v1 = iy * 1.0f / 256.0f;
	float u2 = (ix+12) * 1.0f / 256.0f;
	float v2 = (iy+24) * 1.0f / 256.0f;

	vert.flags = TA_VERTEX_NORMAL;
	vert.x = x1;
	vert.y = y1 + 16.0f;
	vert.z = z1;
	vert.u = u1;
	vert.v = v2;
	vert.dummy1 = vert.dummy2 = 0;
	vert.a = a;
	vert.r = r;
	vert.g = g;
	vert.b = b;
	vert.oa = vert.or = vert.og = vert.ob = 0.0f;
	ta->commit_vertex(&vert, sizeof(vert));
	
	vert.x = x1;
	vert.y = y1;
	vert.u = u1;
	vert.v = v1;
	ta->commit_vertex(&vert, sizeof(vert));
	
	vert.x = x1 + 12.0f;
	vert.y = y1 + 16.0f;
	vert.u = u2;
	vert.v = v2;
	ta->commit_vertex(&vert, sizeof(vert));

	vert.flags = TA_VERTEX_EOL;
	vert.x = x1 + 12.0f;
	vert.y = y1;
	vert.u = u2;
	vert.v = v1;
	ta->commit_vertex(&vert, sizeof(vert));
}

/* Draw a string (12x24 font) */
void jam_draw_string(float x, float y, float z, float a, float r,
		float g, float b, char *str) {
	poly_hdr_t poly;
	ta->poly_hdr_txr(&poly, TA_TRANSLUCENT, TA_ARGB4444, 256, 256,
		util_texture, TA_BILINEAR_FILTER);
	ta->commit_poly_hdr(&poly);

	while (*str)
		jam_draw_char(x+=12, y, z, a, r, g, b, *str++);
}

/* Draw a single colored box */
void jam_draw_box(float x1, float y1, float x2, float y2, float z,
		float a, float r, float g, float b) {
	poly_hdr_t poly;
	vertex_oc_t vert;

	ta->poly_hdr_col(&poly, TA_TRANSLUCENT);
	ta->commit_poly_hdr(&poly);

	vert.flags = TA_VERTEX_NORMAL;
	vert.x = x1; vert.y = y2; vert.z = z;
	vert.a = a; vert.r = r; vert.g = g; vert.b = b;
	ta->commit_vertex(&vert, sizeof(vert));

	vert.y = y1;
	ta->commit_vertex(&vert, sizeof(vert));

	vert.x = x2; vert.y = y2;
	ta->commit_vertex(&vert, sizeof(vert));

	vert.flags = TA_VERTEX_EOL;	
	vert.y = y1;
	ta->commit_vertex(&vert, sizeof(vert));
}

/* Redraw all active windows: currently not thread safe */
static void jam_draw_windows(int phase) {
	jam_window_t *cur = jam_windows;
	
	while (cur != NULL) {
		if (cur->redraw)
			cur->redraw(cur, phase);
		if (jam_mgr)
			jam_mgr->decorate(cur, phase);
		cur = cur->next;
	}
}

/* Do a complete video frame. Note: This will cause a pause for
   vertical blank. */
void jam_repaint() {
	static int framecnt = 0;
	static int col = 0;
	
	/* Begin opaque polygons */
	//printf("Begin render\r\n");
	ta->begin_render();

	/* Draw the background polygon (opaque) */
	//printf("Draw desktop\r\n");
	jam_draw_desktop();

	/* Draw any active opaque window parts */
	//printf("Draw windows\r\n");
	jam_draw_windows(JAM_PHASE_OPAQUE_POLY);
	
	/* Begin translucent polygons */
	//printf("Commit EOL\r\n");
	ta->commit_eol();

	/* Draw any active translucent window parts */
	//printf("Draw windows\r\n");
	jam_draw_windows(JAM_PHASE_TRANS_POLY);

	/* Mouse pointer (translucent) */
	//printf("Draw mouse\r\n");
	jam_draw_mouse();
	
	/* Finish up */
	//printf("Finish frame\r\n");
	ta->commit_eol();
	ta->finish_frame();

	/* Increase frame count */
	framecnt++;
}

