/* KallistiOS 0.6

   test1.c
   (c)2000 Dan Potter

*/

static char id[] = "KOS $Id: test1.c,v 1.1 2000/11/09 05:18:38 bard Exp $";

/* Hypothetical test program */

#include "jam.h"

/* Draws some nifty 3D cubes on the screen */

/* Floating-point Sin/Cos; 256 angles, -1.0 to 1.0 */
#include "sintab.h"
#define sin(angle) sintab[angle]
#define cos(angle) sintab[((angle)+64) % 256]


/* Cube data is now an ordered list of triangle strips */
#define NUM_FACES 6
int cube_points[] = {
	-1, -1,  1,	/* Front plane */
	-1,  1,  1,
	 1, -1,  1,
	 1,  1,  1,

	 1, -1, -1,	/* Back plane */
	 1,  1, -1,
	-1, -1, -1,
	-1,  1, -1,

	-1, -1, -1,	/* Left plane */
	-1,  1, -1,
	-1, -1,  1,
	-1,  1,  1,

	 1, -1,  1,	/* Right plane */
	 1,  1,  1,
	 1, -1, -1,
	 1,  1, -1,

	-1, -1, -1,	/* Top plane */
	-1, -1,  1,
	 1, -1, -1,
	 1, -1,  1,
	
	-1,  1,  1,	/* Bottom plane */
	-1,  1, -1,
	 1,  1,  1,
	 1,  1, -1
};


int rotang = 0;
#define zkonst 128
#define mult 64
float cubesize = 0.0f;
void draw_cube(float xtrans, float ytrans, float ztrans) {
	int cp = 0;
	int ra, rao, ra2;
	float x, y, z, tx, ty, tz;
	float xt, yt;
	vertex_oc_t vert;

	if (cubesize < 0.1f)
		return;

	ra = (rotang*2) % 256;
	ra2 = (rotang/2);
	
	for (cp=0; cp<(NUM_FACES*4*3); cp+=3) {
		x = cube_points[cp+0] * mult * cubesize;
		y = cube_points[cp+1] * mult * cubesize;
		z = cube_points[cp+2] * mult * cubesize;

		tx = (cos(ra)*x - sin(ra)*y);
		ty = (cos(ra)*y + sin(ra)*x);
		x = tx; y = ty;
		
		tz = (cos(ra2)*z - sin(ra2)*y);
		ty = (cos(ra2)*y + sin(ra2)*z);
		y = ty; z = tz;

		tx = (cos(ra)*x - sin(ra)*z);
		tz = (cos(ra)*z + sin(ra)*x);
		x = tx; z = tz;
		
		z += ztrans;

		xt = (x*zkonst) / (zkonst+z+mult);
		yt = (y*zkonst) / (zkonst+z+mult);

		xt += xtrans;
		yt += ytrans;

		if ((cp % 12) == 9)
			vert.flags = 0xf0000000;
		else
			vert.flags = 0xe0000000;
		vert.x = xt; vert.y = yt; vert.z = ztrans+1.0f - ((z-ztrans)/128.0f);
		vert.a = 0.8f;
		if (ztrans == 0) ztrans++;
		switch((cp % 4)) {
			case 0:
				vert.r = 192.0f/ztrans; vert.g = 0.0f; vert.b = 0.0f;
				break;
			case 1:
				vert.r = 0.0f; vert.g = 192.0f/ztrans; vert.b = 0.0f;
				break;
			case 2:
				vert.r = 0.0f; vert.g = 0.0f; vert.b = 192.0f/ztrans;
				break;
			case 3:
				vert.r = 192.0f/ztrans; vert.g = 192.0f/ztrans; vert.b = 0.0f;
				break;
		}

		ta->commit_vertex(&vert, sizeof(vert));
	}
}

/* Draw six cubes arranged in a circle */
int zooming = 1;
void cube_one_frame(float xtrans, float ytrans, float ztrans, int move) {
	int i, j;

	if (move) {
		rotang = (rotang+1) % 512;

		if (cubesize < 1.0f) {
			cubesize += 1/85.0f;
		}
	}
	draw_cube(xtrans, ytrans, ztrans);
}


/* These next two functions are the test window handlers; they've gotta
   be _rather_ re-entrant =) */
int test_event(jam_window_t *wnd, jam_event_t *evt) {
	return 0;
}

jam_window_t *wnds[7];
int test_paint(jam_window_t *wnd, int phase) {
	switch (phase) {
		case JAM_PHASE_OPAQUE_POLY:		/* Opaque: nothin' */
			break;
		case JAM_PHASE_TRANS_POLY:	{	/* Translucent */
		
	poly_hdr_t	poly;
	vertex_oc_t	vert;

	/* Start a colored polygon set */
	ta->poly_hdr_col(&poly,TA_TRANSLUCENT);
	ta->commit_poly_hdr(&poly);

	if (wnd == wnds[1])
		cube_one_frame(wnd->x1 + wnd->w/2, wnd->y1 + wnd->h/2, wnd->z1,1);
	else
		cube_one_frame(wnd->x1 + wnd->w/2, wnd->y1 + wnd->h/2, wnd->z1,0);

	//blit_font_texture();
}} return 0;}


int test_main() {
	printf("win_create 1\r\n");
	wnds[0] = jam_win_create(10.0f, 10.0f, 300.0f, 300.0f, test_paint, test_event, "Test Cube 1", 0);
	printf("win_create 2\r\n");
	wnds[1] = jam_win_create(30.0f, 30.0f, 300.0f, 300.0f, test_paint, test_event, "Test Cube 2", 0);
/*	printf("win_create 3\r\n");
	wnds[2] = jam_win_create(60.0f, 60.0f, 300.0f, 300.0f, test_paint, test_event, "Test Cube 3", 0);
	printf("win_create 4\r\n");
	wnds[3] = jam_win_create(90.0f, 90.0f, 300.0f, 300.0f, test_paint, test_event, "Test Cube 4", 0);
	printf("win_create 5\r\n");
	wnds[4] = jam_win_create(120.0f, 120.0f, 300.0f, 300.0f, test_paint, test_event, "Test Cube 5", 0);
	printf("win_create 6\r\n");
	wnds[5] = jam_win_create(150.0f, 150.0f, 300.0f, 300.0f, test_paint, test_event, "Test Cube 6", 0);
	printf("win_create 7\r\n");
	wnds[6] = jam_win_create(180.0f, 180.0f, 300.0f, 300.0f, test_paint, test_event, "Test Cube 7", 0); */
}
