/* KallistiOS 0.6

   wm.c
   (c)2000 Dan Potter

*/

static char id[] = "KOS $Id: wm.c,v 1.1 2000/11/09 05:18:38 bard Exp $";

#include "jam.h"

/* Aqua texture */
static uint32 aq_texture;

#define AQUA_GRAY_BTN_LEFT	0
#define AQUA_GRAY_BTN_MID	1
#define AQUA_GRAY_BTN_RIGHT	2
#define AQUA_GRAY_BUBBLE	3
#define AQUA_TB			4
#define AQUA_SHADOW		5

#define AQUA_U		128.0f
#define AQUA_V		64.0f
#define AQUA_X		128
#define AQUA_Y		64

static struct {
	float u1, v1;
	float u2, v2;
} aq_loc[6] = {
	{1.0f/AQUA_U, 0.0f/AQUA_V,	11.0f/AQUA_U, 19.0f/AQUA_V},
	{12.0f/AQUA_U, 0.0f/AQUA_V,	53.0f/AQUA_U, 19.0f/AQUA_V},
	{54.0f/AQUA_U, 0.0f/AQUA_V,	64.0f/AQUA_U, 19.0f/AQUA_V},
	{66.0f/AQUA_U, 2.0f/AQUA_V,	(66.0f+12.0f)/AQUA_U, (2.0f+14.0f)/AQUA_V},
	{0.0f/AQUA_U, 21.0f/AQUA_V,	116.0f/AQUA_U, 42.0f/AQUA_V},
	{84.0f/AQUA_U, 0.0f/AQUA_V,	(84.0f+18.0f)/AQUA_U, 18.0f/AQUA_V}
};

/* The window with focus */
static jam_window_t *focused = NULL;

/* Start a polygon set with the Aqua texure */
static void aq_start(int filtering) {
	poly_hdr_t poly;
	
	ta->poly_hdr_txr(&poly, TA_TRANSLUCENT, TA_ARGB4444, AQUA_U, AQUA_V,
		aq_texture, filtering);
	ta->commit_poly_hdr(&poly);
}

/* Draw an Aqua item */
static void aq_item(int idx, float x1, float y1, float x2, float y2, float z,
		float a, float r, float g, float b) {
	vertex_ot_t vert;
	float u1 = aq_loc[idx].u1, v1 = aq_loc[idx].v1;
	float u2 = aq_loc[idx].u2, v2 = aq_loc[idx].v2;

	if (x2 == -1.0f && y2 == -1.0f) {
		x2 = x1 + (u2 - u1)*AQUA_U;
		y2 = y1 + (v2 - v1)*AQUA_V;
	}
	
	vert.flags = TA_VERTEX_NORMAL;
	vert.x = x1; vert.y = y2; vert.z = z;
	vert.u = aq_loc[idx].u1; vert.v = aq_loc[idx].v2;
	vert.a = a; vert.r = r; vert.g = g; vert.b = b;
	vert.oa = vert.or = vert.og = vert.ob = 0.0f;
	ta->commit_vertex(&vert, sizeof(vert));
	
	vert.y = y1; vert.v = aq_loc[idx].v1;
	ta->commit_vertex(&vert, sizeof(vert));
	
	vert.x = x2; vert.y = y2;
	vert.u = aq_loc[idx].u2; vert.v = aq_loc[idx].v2;
	ta->commit_vertex(&vert, sizeof(vert));
	
	vert.flags = TA_VERTEX_EOL;
	vert.y = y1; vert.v = aq_loc[idx].v1;
	ta->commit_vertex(&vert, sizeof(vert));
}

void wm_draw_button(float x1, float y1, float z, int type, float adjust, char *text) {
	float r, g, b;
	int tlen = 0;

	switch(type) {
		case 0:
			r = 0.671f;
			g = 0.863f;
			b = 0.984f;
			break;
		case 1:
			r = 1.0f;
			g = 1.0f;
			b = 1.0f;
			break;
	}
	r *= adjust;
	g *= adjust;
	b *= adjust;
	
	if (text != NULL)
		tlen = strlen(text);
	else
		tlen = 64/12;

	/* Draw button base */
	aq_start(TA_NO_FILTER);
	aq_item(AQUA_GRAY_BTN_LEFT, x1, y1, x1+10.0f, y1+20.0f, z, 1.0f, r, g, b);
	aq_item(AQUA_GRAY_BTN_MID, x1+10.0f, y1, x1+36.0f+12.0f*tlen, y1+20.0f, z, 1.0f, r, g, b);
	aq_item(AQUA_GRAY_BTN_RIGHT, x1+36.0f+12.0f*tlen, y1, x1+36.0f+12.0f*tlen+10.0f, y1+20.0f,
		z, 1.0f, r, g, b);
	
	/* Draw text */
	if (text != NULL) {
		jam_draw_string(x1+12.0f, y1+2.0f, z+0.1f,
			1.0f, 0.0f, 0.0f, 0.0f, text);
	}
}

/* Find decoration size */
int decor_set_sizes(jam_window_t *wnd) {
	wnd->rx1 = wnd->x1;
	wnd->ry1 = wnd->y1 - 18;
	wnd->rw = wnd->w;
	wnd->rh = wnd->h + 18;
	return 0;
}

/* Decorate a window */
int decorate(jam_window_t *wnd, int phase) {
	if (phase == JAM_PHASE_TRANS_POLY) {
		float fade = 1.0f;
		
		if (wnd != focused)
			fade = 0.7f;
		
		/* Window title background */
		/*jam_draw_box(wnd->x1, wnd->ry1, wnd->x1+wnd->w-1, wnd->y1, wnd->z1,
			0.5f, 0.3f, 0.0f, 0.4f); */
		aq_start(TA_NO_FILTER);
		aq_item(AQUA_TB, wnd->x1, wnd->ry1, wnd->x1+wnd->w-1, wnd->y1, wnd->z1,
			0.7f, 1.0f*fade, 1.0f*fade, 1.0f*fade);
			
		/* Window close button */
		aq_item(AQUA_GRAY_BUBBLE, wnd->x1+5.0f, (wnd->ry1+wnd->y1)/2-7.0f,
			-1, -1, wnd->z1+0.2f, 1.0f,
			fade!=1.0f?1.0f:0.0f,
			fade,
			fade!=1.0f?1.0f:0.0f);

		/* Window shadows */
		jam_draw_box(wnd->rx1+wnd->rw,  wnd->ry1+10.0f,
			wnd->rx1+wnd->rw+10.0f, wnd->ry1+wnd->rh+10.0f,
			wnd->z1-0.1f, 0.2f, 0.0f, 0.0f, 0.0f);
		jam_draw_box(wnd->rx1+10.0f,  wnd->ry1+wnd->rh,
			wnd->rx1+wnd->rw, wnd->ry1+wnd->rh+10.0f,
			wnd->z1-0.1f, 0.2f, 0.0f, 0.0f, 0.0f);

		/* Window title text */
		jam_draw_string(wnd->rx1+5.0f+14.0f+5.0f, wnd->ry1+1.0f, wnd->z1+0.2f,
			1.0f, 0.0f, 0.0f, 0.0f, wnd->title);
		/*aq_str(wnd->rx1+5.0f+14.0f+5.0f, wnd->ry1+1.0f, wnd->z1+0.2f,
			1.0f, 0.0f, 0.0f, 0.0f, wnd->title);*/
			
		/* Window background */
		jam_draw_box(wnd->x1, wnd->y1, wnd->x1+wnd->w-1, wnd->y1+wnd->h-1,
			wnd->z1, 0.6f, 1.0f, 1.0f, 1.0f);
	}
	
	return 0;
}

/* Process a window event */
static int dlx = -1, dly = -1;
int decor_event(jam_window_t *wnd, jam_event_t *evt) {
	//printf("%08x: Received event of type %04x, x=%d, y=%d, btn=%04x\r\n", wnd,
	//	evt->type, evt->x, evt->y, evt->button);
	
	if (evt->type == JAM_EVT_BTNPRESS) {	/* Start a drag */
		dlx = evt->x;
		dly = evt->y;
		jam_input_lock(wnd);
		jam_win_restack_top(wnd);
		focused = wnd;
		//printf("%d: Button pressed at %d,%d, ix,iy<-%d,%d\r\n", which, evt->x, evt->y,
		//	wnd->x1, wnd->y1);
	} else if (evt->type == JAM_EVT_BTNRELEASE) {	/* Finish drag */
		dlx = -1;
		jam_input_unlock();
		//printf("%d: Button released at %d,%d\r\n", which, evt->x, evt->y);
	} else if (evt->type == JAM_EVT_CURSORMOVE && dlx != -1) {
		int x = wnd->x1 + (evt->x - dlx);
		int y = wnd->y1 + (evt->y - dly);
		//printf("Moving window to %d,%d\r\n", x, y);
		jam_win_move(wnd, x, y);
	}
	
	return 0;
}

/* Initialize window manager textures */
#include "aqua_texture.h"
static void init_textures() {
	uint16 *vram;
	int x, y, v, a, r, g, b;
	
	aq_texture = jam_texture_alloc(AQUA_X*AQUA_Y*2);
	vram = (uint16*)ta->texture_map(aq_texture);
	
	printf("Writing aq texture to %08x\r\n", vram);
	
	for (y=0; y<AQUA_Y; y++) {
		for (x=0; x<AQUA_X; x++) {
			r = aqua_texture[(y*AQUA_X+x)*4+0];
			g = aqua_texture[(y*AQUA_X+x)*4+1];
			b = aqua_texture[(y*AQUA_X+x)*4+2];
			a = aqua_texture[(y*AQUA_X+x)*4+3];
			v = ((a >> 4) << 12)
				| ((r >> 4) << 8)
				| ((g >> 4) << 4)
				| ((b >> 4) << 0);
			*vram++ = v;
		}
	}
}


/* Window manager structure */
static jam_window_manager_t mgr = {
	decor_set_sizes,
	decorate,
	decor_event
};

/* Initialize the built-in window manager */
int jam_wm_init() {
	/* aq_texture = 0x700000; */
	init_textures();
	return jam_set_window_manager(&mgr);
}






