/*
 * conio.h - conio service
 *
 * (C) 2000 Jordan DeLong
 */
#ifndef _KOSH_ABI_CONIO_H
#define _KOSH_ABI_CONIO_H

#include <kallisti/process.h>
#include "../conio.h"

typedef struct {
	service_abi_t	hdr;			/* header info */

	cursor_t *cursor;			/* the cursor */

	void 	(*scroll)();			/* scroll the screen 1 row */
	void 	(*deadvance_cursor)();		/* move cursor back one col, wrapping as neccs */
	void	(*advance_cursor)();		/* move cursor forward, scroll if neccs */
	void	(*gotoxy)(int x, int y);	/* move the cursor coordinates */
	int	(*getch)();			/* get a character: block while waiting. use maple->kbd_get_key for non-blocking */
	void	(*setch)(int ch);		/* put a char & don't advance cursor */
	void	(*putch)(int ch);		/* put a char & advance cursor */
	void	(*putstr)(char *str);		/* put a string */
	int	(*printf)(const char *fmt, ...);/* printf to the console */
	void	(*clear)();			/* clear the console */
} abi_conio_t;

#endif
