/* KallistiOS ##kernel##
   Userland library

   fs.c
   (c)2000 Dan Potter
*/

static char id[] = "KOS $Id: fs.c,v 1.1 2000/11/09 05:25:42 bard Exp $";

/*

Wrappers for the VFS functions starting with fs_ in the kernel.

*/

#include <libk.h>
#include <kallisti/abi/fs.h>

static abi_fs_t *fsabi = NULL;

uint32		fs_open(char *fn, int mode) { return fsabi->open(fn, mode); }
void		fs_close(uint32 hnd) { fsabi->close(hnd); }
ssize_t		fs_read(uint32 hnd, void *buffer, size_t cnt) {
	return fsabi->read(hnd, buffer, cnt);
}
ssize_t		fs_write(uint32 hnd, void *buffer, size_t cnt) {
	return fsabi->write(hnd, buffer, cnt);
}
off_t		fs_seek(uint32 hnd, off_t offset, int whence) {
	return fsabi->seek(hnd, offset, whence);
}
off_t		fs_tell(uint32 hnd) { return fsabi->tell(hnd); }
size_t		fs_total(uint32 hnd) { return fsabi->total(hnd); }
dirent_t*	fs_readdir(uint32 hnd) { return fsabi->readdir(hnd); }

int		fs_handler_add(char *prefix, vfs_handler *hnd) {
	return fsabi->handler_add(prefix, hnd);
}

int		fs_handler_remove(vfs_handler *hnd) {
	return fsabi->handler_remove(hnd);
}


int fs_abi_init() {
	if (fsabi == NULL) {
		fsabi = (abi_fs_t*)ko_get_svc("fs");
		if (fsabi == NULL)
			return -1;
	}
	return 0;
}


