/* KallistiOS 0.6
   Userland library

   libk.c
   (c)2000 Dan Potter
*/

static char id[] = "KOS $Id: libk.c,v 1.1 2000/11/09 05:25:42 bard Exp $";

/*

This handles the program entry and exit, along with grabbing and setting
up the fundamental services. This is a bit messy looking at the moment...

*/

#include <string.h>

/* This is filled in by the kernel when loading the binary */
void* (*ko_get_svc)(char *name) = NULL;

/* Fundamental service struct */
#include <kallisti/abi/fundamental.h>
static abi_fundamental_t *fabi = NULL;


/* Fundamental service handlers */

/* Printf is a special case because of its variable args */
extern int printf(const char *fmt, ...);
extern uint32 printf_addr;
asm("
	.text
	.global _printf
_printf:
	mov.l	r0,@-r15
	mov.l	_printf_addr,r0
	jmp	@r0
	mov.l	@r15+,r0

	.align 4
_printf_addr:
	.long	0
");

/* Everything else we just pass through */
void* malloc(size_t size) { return fabi->malloc(size); }
void free(void *ptr) { return fabi->free(ptr); }
void* memalign(size_t size, size_t align) { return fabi->memalign(size, align); }

/* This is the entry point inside the C program */
int main(int argc, char **argv);
int ko_main(int argc, char **argv) {
	/* Check for WTF up front */
	if (ko_get_svc == NULL)
		return -1;

	/* Setup the fundamental ABI structure */
	fabi = (abi_fundamental_t*)ko_get_svc("fundamental");
	if (fabi == NULL)
		return -1;

	/* Check for compatable ABI version */	
	if (ABI_VER_MAJOR(fabi->hdr.version) != 1)
		return -1;

	printf_addr = (uint32)fabi->printf;

	fabi->printf("fabi version works\r\n");
	printf("libk started; jumping to main (%08x)\r\n", main);

	return main(argc, argv);
}

/* Notify function.. for now we note its usage and otherwise ignore */
int ko_notify(int event) {
	if (printf_addr != 0) {
		printf("Received kernel event %08x\r\n", event);
		return 0;
	} else {
		return -1;
	}
}

/* When you make a function called main() in a GCC program, it wants
   this stuff too. */
void __main() { }
void atexit() { }

