/* KallistiOS 0.6
   Userland library

   spu.c
   (c)2000 Dan Potter
*/

static char id[] = "KOS $Id: spu.c,v 1.1 2000/11/09 05:25:42 bard Exp $";

/*

Wrappers for the Sound Processor Unit functions starting with spu_
in the kernel.

*/

#include <libk.h>
#include <kallisti/abi/spu.h>

static abi_spu_t *wasabi = NULL;	/* heh */

void spu_ram_write_wait() { wasabi->ram_write_wait(); }
void spu_memload(uint32 to, uint8* from, int len)
	{ wasabi->memload(to, from, len); }
void spu_memset(uint32 to, uint32 what, int len)
	{ wasabi->memset(to, what, len); }
void spu_enable() { wasabi->enable(); }
void spu_disable() { wasabi->disable(); }

int spu_abi_init() {
	if (wasabi == NULL) {
		wasabi = (abi_spu_t*)ko_get_svc("spu");
		if (wasabi == NULL)
			return -1;
	}
	
	return 0;
}


