/* KallistiOS 0.6
   Userland library

   ta.c
   (c)2000 Dan Potter
*/

static char id[] = "KOS $Id: ta.c,v 1.1 2000/11/09 05:25:42 bard Exp $";

/*

Wrappers for the Tile Accelerator functions starting with ta_ in the kernel.

*/

#include <libk.h>
#include <kallisti/abi/ta.h>

static abi_ta_t *tabi = NULL;
ta_bkg_poly *ta_bkg = NULL;

void ta_send_queue(void *sql, int size) { return tabi->send_queue(sql, size); }
void ta_begin_render() { return tabi->begin_render(); }
void ta_commit_poly_hdr(void *polyhdr) { return tabi->commit_poly_hdr(polyhdr); }
void ta_commit_vertex(void *vertex, int size) { return tabi->commit_vertex(vertex,size); }
void ta_commit_eol() { return tabi->commit_eol(); }
void ta_finish_frame() { return tabi->finish_frame(); }

int ta_abi_init() {
	if (tabi == NULL) {
		tabi = (abi_ta_t*)ko_get_svc("ta");
		if (tabi == NULL)
			return -1;
	}
	
	ta_bkg = tabi->bkg;
	return 0;
}


