/* KallistiOS 0.6

   Host-side serial console handler
   (c)2000 Dan Potter

*/

static char id[] = "$Id: konsole.c,v 1.2 2000/11/09 05:31:31 bard Exp $";

#include <stdlib.h>
#include <stdio.h>

/* In console.c */
void console();

/* Call dc-tool to send a program first */
void upload_and_console(char *fn) {
	char cmd[256] = "dc-tool -n -x ";
	
	strncat(cmd, fn, 128);
	if (system(cmd) == 0)
		console();
}

int main(int argc, char **argv) {
	fprintf(stderr, "KallistiOS Host-side serial console\n");

	/* Check args */
	argc--;
	if (argc < 1 || argv[1][0] != '-' || (argv[1][1] != 'x' && argv[1][1]  != 'c')) {
		fprintf(stderr,"usage: konsole (-x <filename> | -c)\n");
		return -1;
	}

	/* Check the function */
	if (argv[1][1] == 'x')
		upload_and_console(argv[2]);
	else
		console();

	return 0;
}

