/* KallistiOS 0.6

   Host-side serial console handler
   (c)2000 Dan Potter

   Some thanks to andrewk on getting these termio params worked out.. ^_^;;

*/

static char id[] = "KOS $Id: serial.c,v 1.3 2000/11/12 01:09:00 bard Exp $";

#include <stdio.h>
#include <fcntl.h>
#include <termios.h>


int serfd;
struct termios oldios;

int ser_init(char *dev, int baud) {
	struct termios tios;

	serfd = open(dev, O_RDWR | O_NOCTTY);
	if (serfd < 0) {
		printf("couldn't open device %s at baud %d\n", dev, baud);
	}
	
	if (tcgetattr(serfd, &oldios) < 0) {
		perror("couldn't get current termio parameters");
		return -1;
	}
	
	memset(&tios, 0, sizeof(tios));
	
	/* Input flags */
	tios.c_iflag = 0;
	
	/* Output flags */
	tios.c_oflag = 0;
	
	/* Control flags */
	tios.c_cflag = CRTSCTS | CS8 | CLOCAL | CREAD;
	
	/* Local flags */
	tios.c_lflag = 0;
	
	/* Misc character flags */
	tios.c_cc[VTIME] = 0;
	tios.c_cc[VMIN] = 1;
	
	/* Translate the baud rate */
	if (baud == 38400)
		baud = B38400;
	else if (baud == 57600)
		baud = B57600;
	else if (baud == 115200)
		baud = B115200;
	else {
		printf("unknown baud rate %d, using 57600\n", baud);
		baud = B57600;
	}

	tios.c_cflag |= baud;
	tcflush(serfd, TCIFLUSH);	
	if (tcsetattr(serfd, TCSANOW, &tios) < 0) {
		perror("Couldn't set termio parameters for serial");
		return -1;
	}

	//cfsetispeed(&tios, baud);
	//cfsetospeed(&tios, baud);
	
	return 0;
}

void ser_close() {
	close(serfd);
}

void ser_putch(int ch) {
	char chbuf[1] = { (char)ch };
	if (write(serfd, chbuf, 1) < 0) {
		perror("couldn't write serial byte");
	}
}

int ser_getch() {
	char chbuf[1] = { 0 };
	if (read(serfd, chbuf, 1) < 1) {
		perror("couldn't read serial byte");
	}
	return chbuf[0];
}


